/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.vellamo;

import com.sun.management.OperatingSystemMXBean;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.gui.base.enumText.QualityType;
import team.teampotato.ruok.util.OSysInfo;
import team.teampotato.ruok.util.Quality;
import team.teampotato.ruok.util.ToastUtil;

public class Score {
    private static final double cpu;
    private static final double ram;

    @Contract(pure=true)
    public static void runVellamo() {
        int fps = Minecraft.m_91087_().m_260875_();
        double time = RuOK.get().startTime;
        double score = 0.5 * (100.0 - cpu) + 0.4 * (100.0 - ram) + 0.1 * (double)fps + 0.1 * (1000.0 / time);
        Component level = Score.calculatePerformanceLevel(score);
        ToastUtil.send((Component)Component.m_237115_((String)"ruok.quality.runscore.info"), (Component)Component.m_237110_((String)"ruok.vellamo.recommend", (Object[])new Object[]{level}));
    }

    @NotNull
    private static Component calculatePerformanceLevel(double score) {
        if (score > 90.0) {
            Quality.set(QualityType.ULTRA);
            return Component.m_237115_((String)"ruok.quality.ultra");
        }
        if (score > 70.0) {
            Quality.set(QualityType.HIGH);
            return Component.m_237115_((String)"ruok.quality.high");
        }
        if (score > 50.0) {
            Quality.set(QualityType.NORMAL);
            return Component.m_237115_((String)"ruok.quality.normal");
        }
        if (score > 30.0) {
            Quality.set(QualityType.LOW);
            return Component.m_237115_((String)"ruok.quality.low");
        }
        Quality.set(QualityType.CRITICAL);
        return Component.m_237115_((String)"ruok.quality.critical");
    }

    static {
        OperatingSystemMXBean osmxb = OSysInfo.getSystem.getOsmxb();
        double mem = (double)osmxb.getFreeMemorySize() / (double)osmxb.getTotalMemorySize();
        double memoryLoad = (1.0 - mem) * 100.0;
        double cpuLoad = osmxb.getCpuLoad() * 100.0;
        memoryLoad = Double.parseDouble(String.format("%.1f", memoryLoad));
        cpu = cpuLoad = Double.parseDouble(String.format("%.1f", cpuLoad));
        ram = memoryLoad;
    }
}

