/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.render.text;

import java.text.DecimalFormat;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class LocalServerInfo {
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("########0.00");
    private static int delay = 0;
    private static Component LOCAL_SERVER_INFO_TEXT = LocalServerInfo.getText();

    public static void refInfo() {
        if (++delay > 5) {
            LOCAL_SERVER_INFO_TEXT = LocalServerInfo.getText();
            delay = 0;
        }
    }

    public static Component getLocalServerInfoText() {
        return LOCAL_SERVER_INFO_TEXT;
    }

    private static Component getText() {
        IntegratedServer cs = Minecraft.m_91087_().m_91092_();
        double meanTickTime = 0.0;
        if (cs != null) {
            meanTickTime = (double)LocalServerInfo.mean(cs.f_129748_) * 1.0E-6;
        }
        double meanTPS = Math.min(1000.0 / meanTickTime, 20.0);
        MutableComponent tps = Component.m_237113_((String)TIME_FORMATTER.format(meanTPS));
        Style style = tps.m_7383_();
        if (meanTPS > 16.0) {
            tps.m_6270_(style.m_131140_(ChatFormatting.GREEN));
        } else if (meanTPS > 12.0) {
            tps.m_6270_(style.m_131140_(ChatFormatting.YELLOW));
        } else if (meanTPS > 8.0) {
            tps.m_6270_(style.m_131140_(ChatFormatting.GOLD));
        } else {
            tps.m_6270_(style.m_131140_(ChatFormatting.RED));
        }
        MutableComponent tick = Component.m_237113_((String)TIME_FORMATTER.format(meanTickTime));
        if (meanTickTime > 100.0) {
            tick.m_6270_(style.m_131140_(ChatFormatting.RED));
        } else if (meanTickTime > 50.0) {
            tick.m_6270_(style.m_131140_(ChatFormatting.GOLD));
        } else if (meanTickTime > 30.0) {
            tick.m_6270_(style.m_131140_(ChatFormatting.YELLOW));
        } else {
            tick.m_6270_(style.m_131140_(ChatFormatting.GREEN));
        }
        return Component.m_237110_((String)"ruok.options.gui.server.local.ticktime", (Object[])new Object[]{tick, tps});
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }
}

