/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.render.compat;

import it.unimi.dsi.fastutil.objects.Object2IntFunction;
import net.irisshaders.batchedentityrendering.impl.Groupable;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.layer.EntityRenderStateShard;
import net.irisshaders.iris.layer.OuterWrappedRenderType;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.ZombieVillager;

public class IrisCompat {
    private static final NamespacedId SHADOW_ID = new NamespacedId("minecraft", "entity_shadow");
    private static int cachedEntityId = 0;
    private static final WorldRenderingSettings RENDER_SETTINGS = WorldRenderingSettings.INSTANCE;

    public static boolean maybeSuppressShadow() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipelineNullable();
        return pipeline != null && pipeline.shouldDisableVanillaEntityShadows();
    }

    public static void restoreShadow() {
        if (cachedEntityId != 0) {
            CapturedRenderingState.INSTANCE.setCurrentEntity(cachedEntityId);
            cachedEntityId = 0;
        }
    }

    public static void maybeSuppressEntityShadow() {
        if (!IrisCompat.maybeSuppressShadow()) {
            Object2IntFunction entityIds = RENDER_SETTINGS.getEntityIds();
            if (entityIds == null) {
                return;
            }
            cachedEntityId = CapturedRenderingState.INSTANCE.getCurrentRenderedEntity();
            CapturedRenderingState.INSTANCE.setCurrentEntity(entityIds.getInt((Object)SHADOW_ID));
        }
    }

    public static void endEntityRender() {
        CapturedRenderingState.INSTANCE.setCurrentEntity(0);
        CapturedRenderingState.INSTANCE.setCurrentRenderedItem(0);
    }

    public static MultiBufferSource beginEntityRender(MultiBufferSource bufferSource, Entity entity) {
        int entityId;
        ZombieVillager zombie;
        if (!(bufferSource instanceof Groupable)) {
            return bufferSource;
        }
        Object2IntFunction entityIds = RENDER_SETTINGS.getEntityIds();
        if (entityIds == null) {
            return bufferSource;
        }
        if (entity instanceof ZombieVillager && (zombie = (ZombieVillager)entity).m_34408_() && RENDER_SETTINGS.hasVillagerConversionId()) {
            entityId = entityIds.applyAsInt((Object)new NamespacedId("minecraft", "zombie_villager_converting"));
        } else {
            ResourceLocation mcEntityId = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
            entityId = entityIds.applyAsInt((Object)new NamespacedId(mcEntityId.m_135827_(), mcEntityId.m_135815_()));
        }
        CapturedRenderingState.INSTANCE.setCurrentEntity(entityId);
        return type -> bufferSource.m_6299_((RenderType)OuterWrappedRenderType.wrapExactlyOnce((String)"iris:is_entity", (RenderType)type, (RenderStateShard)EntityRenderStateShard.INSTANCE));
    }
}

