/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.render;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.config.RuOKConfig;
import team.teampotato.ruok.util.FPSUtil;
import team.teampotato.ruok.util.OSysInfo;
import team.teampotato.ruok.util.render.text.LocalServerInfo;

public class TextRender {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static int maxFPS = 0;
    private static Component GPU_TEXT = TextRender.formatColor((int)Math.min(Minecraft.m_91087_().m_231464_(), 100.0));
    private static int delay = 0;
    private static int delayText = 0;
    private static Component RAM_TEXT = TextRender.getRamText();
    private static Component CPU_TEXT = TextRender.getCPUText();
    private static Component CAMERA_TO_BLOCK = TextRender.getBlockToPlayerPos();

    public static MutableComponent formatColor(int v) {
        MutableComponent text = Component.m_237113_((String)String.valueOf(v));
        if (v > 80) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.RED));
        }
        if (v > 70) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.YELLOW));
        }
        if (v > 30) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.GREEN));
        }
        return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.GREEN));
    }

    public static Component formatFpsColor(int fps) {
        MutableComponent text = Component.m_237113_((String)String.valueOf(fps));
        if (fps > 58) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.GREEN));
        }
        if (fps > 48) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.YELLOW));
        }
        if (fps > 28) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.GOLD));
        }
        return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.RED));
    }

    public static Component formatRXTXColor(float v) {
        MutableComponent text = Component.m_237113_((String)String.valueOf(v));
        if (v > 3000.0f) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.RED));
        }
        if (v > 2000.0f) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.GOLD));
        }
        if (v > 1000.0f) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.YELLOW));
        }
        if (v > 500.0f) {
            return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.GREEN));
        }
        return text.m_6270_(text.m_7383_().m_131140_(ChatFormatting.GREEN));
    }

    public static void draw(GuiGraphics context, Minecraft mc) {
        if (RuOK.get().onGui) {
            TextRender.drawText(context, mc);
        }
    }

    private static void drawText(GuiGraphics context, @NotNull Minecraft mc) {
        if (mc.f_91073_ != null) {
            Font tr = mc.f_91062_;
            int color = -1;
            if (!mc.f_91066_.f_92063_) {
                int textHeight;
                int textWidth;
                int n;
                int x;
                RuOKConfig config = RuOK.get();
                if (config.GuiX != 0) {
                    v0 = config.GuiX;
                } else {
                    Objects.requireNonNull(tr);
                    v0 = x = 9 / 2;
                }
                if (config.GuiY != 0) {
                    n = config.GuiY;
                } else {
                    Objects.requireNonNull(tr);
                    n = 9 / 2;
                }
                int y = n;
                Objects.requireNonNull(tr);
                int fh = 9 + 4;
                if (RuOK.get().GuiFPS) {
                    int currentFPS = Minecraft.m_91087_().m_260875_();
                    if (currentFPS > maxFPS) {
                        maxFPS = currentFPS;
                    }
                    FPSUtil.addFPS(currentFPS);
                    long averageFPS = Math.round(FPSUtil.getAverageFPS());
                    MutableComponent fpsText = Component.m_237110_((String)"ruok.options.gui.fps", (Object[])new Object[]{TextRender.formatFpsColor(currentFPS), TextRender.formatFpsColor((int)averageFPS), TextRender.formatFpsColor(maxFPS)});
                    int textWidth2 = tr.m_92852_((FormattedText)fpsText);
                    Objects.requireNonNull(tr);
                    int textHeight2 = 9;
                    TextRender.addTextShadow(context, x, y, textWidth2, textHeight2);
                    context.m_280614_(tr, (Component)fpsText, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().GuiCPU || RuOK.get().GuiRAM || RuOK.get().GuiEntityCount || RuOK.get().GuiGPU) {
                    MutableComponent info = Component.m_237119_();
                    boolean addSeparator = false;
                    if (RuOK.get().GuiCPU) {
                        info.m_7220_((Component)Component.m_237110_((String)"ruok.options.gui.cpu", (Object[])new Object[]{CPU_TEXT}));
                        addSeparator = true;
                    }
                    if (RuOK.get().GuiGPU) {
                        if (addSeparator) {
                            info.m_7220_(Component.m_130674_((String)" | "));
                        }
                        info.m_7220_((Component)Component.m_237110_((String)"ruok.options.gui.gpu", (Object[])new Object[]{GPU_TEXT}));
                        addSeparator = true;
                    }
                    if (RuOK.get().GuiRAM) {
                        if (addSeparator) {
                            info.m_7220_(Component.m_130674_((String)" | "));
                        }
                        info.m_7220_((Component)Component.m_237110_((String)"ruok.options.gui.mem", (Object[])new Object[]{RAM_TEXT}));
                        addSeparator = true;
                    }
                    if (RuOK.get().GuiEntityCount) {
                        if (addSeparator) {
                            info.m_7220_(Component.m_130674_((String)" | "));
                        }
                        info.m_7220_(TextRender.getEntityCount(mc.f_91073_));
                    }
                    textWidth = tr.m_92852_((FormattedText)info);
                    Objects.requireNonNull(tr);
                    int textHeight3 = 9;
                    TextRender.addTextShadow(context, x, y, textWidth, textHeight3);
                    context.m_280614_(tr, (Component)info, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().GuiPlayerPos && mc.f_91074_ != null) {
                    LocalPlayer p = mc.f_91074_;
                    MutableComponent posText = Component.m_237110_((String)"ruok.options.gui.player.pos", (Object[])new Object[]{TextRender.dis(p.m_20185_()), TextRender.dis(p.m_20186_()), TextRender.dis(p.m_20189_())});
                    textWidth = tr.m_92852_((FormattedText)posText);
                    Objects.requireNonNull(tr);
                    int textHeight4 = 9;
                    TextRender.addTextShadow(context, x, y, textWidth, textHeight4);
                    context.m_280614_(tr, (Component)posText, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().GuiServer) {
                    Component serverText = mc.m_91092_() != null ? LocalServerInfo.getLocalServerInfoText() : TextRender.getRemoteServerPing(mc);
                    int textWidth3 = tr.m_92852_((FormattedText)serverText);
                    Objects.requireNonNull(tr);
                    textHeight = 9;
                    TextRender.addTextShadow(context, x, y, textWidth3, textHeight);
                    context.m_280614_(tr, serverText, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().GuiCameraTarget) {
                    int textWidth4 = tr.m_92852_((FormattedText)CAMERA_TO_BLOCK);
                    Objects.requireNonNull(tr);
                    int textHeight5 = 9;
                    TextRender.addTextShadow(context, x, y, textWidth4, textHeight5);
                    context.m_280614_(tr, CAMERA_TO_BLOCK, x, y, color, true);
                    y += fh;
                }
                if (RuOK.get().GuiRXTX) {
                    Component serverIOText = TextRender.getRXTXData(mc);
                    int textWidth5 = tr.m_92852_((FormattedText)serverIOText);
                    Objects.requireNonNull(tr);
                    textHeight = 9;
                    TextRender.addTextShadow(context, x, y, textWidth5, textHeight);
                    context.m_280614_(tr, serverIOText, x, y, color, true);
                }
            }
        }
    }

    private static void addTextShadow(GuiGraphics context, int x, int y, int textWidth, int textHeight) {
        if (RuOK.get().TextBackground) {
            int shadowOffset = 2;
            context.m_280509_(x - shadowOffset, y - shadowOffset, x + textWidth + shadowOffset, y + textHeight + shadowOffset, -1873784752);
        }
    }

    private static Component getCPUText() {
        int cpuLoad = (int)OSysInfo.getSystem.getCpuLoad();
        return TextRender.formatColor(cpuLoad);
    }

    private static Component getRamText() {
        if (RuOK.get().GuiEasyRamMode) {
            return TextRender.handleEasyRamMode();
        }
        return TextRender.handleNormalRamMode();
    }

    private static Component handleEasyRamMode() {
        if (RuOK.get().GuiDisplayRamUsage) {
            return TextRender.displayRamUsage().m_130946_(" ").m_7220_((Component)TextRender.formatColor(OSysInfo.getSystem.getMemoryUsagePercentage())).m_130946_("%");
        }
        return TextRender.formatColor(OSysInfo.getSystem.getMemoryUsagePercentage()).m_130946_("%");
    }

    private static Component handleNormalRamMode() {
        if (RuOK.get().GuiDisplayRamUsage) {
            return TextRender.displayRamUsage().m_130946_(" ").m_7220_(TextRender.formatRamInfo());
        }
        return TextRender.formatRamInfo();
    }

    private static Component formatRamInfo() {
        MutableComponent text = Component.m_237119_();
        text.m_130946_(TextRender.formatByte(OSysInfo.getSystem.getUsedRam()));
        text.m_130946_("/");
        text.m_130946_(TextRender.formatByte(OSysInfo.getSystem.getMaxRam()));
        return text;
    }

    private static String formatByte(double bytes) {
        if (bytes < 1024.0) {
            return bytes + " B";
        }
        if (bytes < 1048576.0) {
            double kb = bytes / 1024.0;
            return String.format("%.2f KB", kb);
        }
        if (bytes < 1.073741824E9) {
            double mb = bytes / 1048576.0;
            return String.format("%.2f MB", mb);
        }
        double gb = bytes / 1.073741824E9;
        return String.format("%.2f GB", gb);
    }

    public static MutableComponent displayRamUsage() {
        MutableComponent text = Component.m_237119_();
        int def = 10;
        int usagePercentage = OSysInfo.getSystem.getMemoryUsagePercentage();
        int numBars = usagePercentage / 10;
        if (numBars > def) {
            numBars = def;
        }
        MutableComponent bar = Component.m_237119_().m_130946_("[");
        for (int i = 0; i < def; ++i) {
            if (i < numBars) {
                float ratio = (float)i / (float)def;
                Style style = (double)ratio < 0.3 ? text.m_7383_().m_131140_(ChatFormatting.GREEN) : ((double)ratio < 0.6 ? text.m_7383_().m_131140_(ChatFormatting.YELLOW) : ((double)ratio < 0.85 ? text.m_7383_().m_131140_(ChatFormatting.GOLD) : text.m_7383_().m_131140_(ChatFormatting.RED)));
                bar.m_7220_((Component)Component.m_237113_((String)"|").m_6270_(style));
                continue;
            }
            bar.m_130946_(" ");
        }
        bar.m_130946_("]");
        return bar;
    }

    public static void refInfo() {
        LocalServerInfo.refInfo();
        ++delayText;
        if (++delay > 20) {
            GPU_TEXT = TextRender.formatColor((int)Math.min(mc.m_231464_(), 100.0));
            delay = 0;
        }
        if (delayText > 10) {
            RAM_TEXT = TextRender.getRamText();
            CPU_TEXT = TextRender.getCPUText();
            delayText = 0;
        }
        CAMERA_TO_BLOCK = TextRender.getBlockToPlayerPos();
    }

    @NotNull
    private static Component getRXTXData(@NotNull Minecraft mc) {
        if (mc.m_91403_() != null) {
            Connection clientConnection = mc.m_91403_().m_104910_();
            float rx = clientConnection.m_129542_();
            float tx = clientConnection.m_129543_();
            return Component.m_237110_((String)"ruok.options.gui.server,remote.dataio", (Object[])new Object[]{TextRender.formatRXTXColor(Math.round(tx)), TextRender.formatRXTXColor(Math.round(rx))});
        }
        return Component.m_237119_();
    }

    private static String dis(double I) {
        return String.format("%.1f", I);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    private static Component getRemoteServerPing(@NotNull Minecraft mc) {
        ClientPacketListener cNet;
        PlayerInfo entry;
        if (mc.f_91074_ != null && mc.m_91403_() != null && (entry = (cNet = mc.m_91403_()).m_104949_(mc.f_91074_.m_20148_())) != null && cNet.m_245416_() != null) {
            String mcs = cNet.m_245416_().f_105363_;
            return Component.m_237110_((String)"ruok.options.gui.server.remote.info", (Object[])new Object[]{mcs, entry.m_105330_()});
        }
        return Component.m_237119_();
    }

    @NotNull
    private static Component getEntityCount(@NotNull ClientLevel world) {
        return Component.m_237110_((String)"ruok.options.gui.entity.count", (Object[])new Object[]{TextRender.formatColor(world.m_104813_())});
    }

    private static Component getBlockToPlayerPos() {
        double md = 300.0;
        Entity ce = mc.m_91288_();
        if (ce != null && TextRender.mc.f_91073_ != null) {
            HitResult bH = ce.m_19907_(md, 1.0f, false);
            if (bH.m_6662_() == HitResult.Type.BLOCK) {
                Vec3 bP = bH.m_82450_();
                Vec3 pP = ce.m_20182_();
                double distance = Math.sqrt(Math.pow(bP.f_82479_ - pP.f_82479_, 2.0) + Math.pow(bP.f_82480_ - pP.f_82480_, 2.0) + Math.pow(bP.f_82481_ - pP.f_82481_, 2.0));
                return Component.m_237110_((String)"ruok.options.gui.camera.pos", (Object[])new Object[]{TextRender.dis(bP.f_82479_), TextRender.dis(bP.f_82480_), TextRender.dis(bP.f_82481_), TextRender.dis(distance)});
            }
            return Component.m_237110_((String)"ruok.options.gui.camera.no_block", (Object[])new Object[]{md});
        }
        return Component.m_237119_();
    }

    public static int fadeColor(int originalColor, float alphaFactor, float rgbFactor) {
        int alpha = (int)((float)(originalColor >> 24 & 0xFF) * alphaFactor);
        int rgb = originalColor & 0xFFFFFF;
        int newR = (int)((float)(rgb >> 16 & 0xFF) * rgbFactor);
        int newG = (int)((float)(rgb >> 8 & 0xFF) * rgbFactor);
        int newB = (int)((float)(rgb & 0xFF) * rgbFactor);
        return alpha << 24 | newR << 16 | newG << 8 | newB;
    }
}

