/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.particle;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.BlockMarker;
import net.minecraft.client.particle.FallingDustParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.mixin.minecraft.ParticleAccessor;
import team.teampotato.ruok.util.render.CameraUtil;

public class ParticleRender {
    private static final Set<ParticleType<?>> blackList = new HashSet();
    private static final Set<ParticleType<?>> whiteList = new HashSet();
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void reloadLists() {
        blackList.clear();
        whiteList.clear();
        for (String id : RuOK.get().BlackListedParticle) {
            ParticleRender.parseType(id).ifPresent(blackList::add);
        }
        for (String id : RuOK.get().WhiteListedParticle) {
            ParticleRender.parseType(id).ifPresent(whiteList::add);
        }
    }

    private static Optional<ParticleType<?>> parseType(String id) {
        return BuiltInRegistries.f_257034_.m_6612_(ResourceLocation.m_135820_((String)id));
    }

    public static <T extends ParticleOptions> void onAddParticle(ParticleEngine manager, Particle particle, T effect, double x, double y, double z) {
        if (ParticleRender.shouldRender(effect)) {
            manager.m_107344_(particle);
        } else {
            particle.m_107274_();
        }
    }

    public static void onAddParticleRaw(Particle particle, CallbackInfo ci) {
        boolean sp = ParticleRender.shouldRawRender(particle);
        if (RuOK.get().ParticlePerformance) {
            return;
        }
        if (!sp) {
            ci.cancel();
        }
    }

    public static boolean shouldRawRender(Particle particle) {
        double maxDistSq;
        if (ParticleRender.isBlockParticle(particle) && !RuOK.get().BlockBreakParticle) {
            return false;
        }
        ParticleAccessor accessor = (ParticleAccessor)particle;
        Vec3 camPos = ParticleRender.mc.f_91063_.m_109153_().m_90583_();
        Vec3 camLook = CameraUtil.getCameraLookVector();
        double fov = CameraUtil.getSafeCullFov();
        if (!ParticleRender.isParticleLooselyInView(camPos, camLook, accessor.getX(), accessor.getY(), accessor.getZ(), fov, 20.0, 0.1)) {
            return false;
        }
        double distSq = camPos.m_82531_(accessor.getX(), accessor.getY(), accessor.getZ());
        return !(distSq > (maxDistSq = Math.pow(RuOK.get().MaxParticleDistance, 2.0)));
    }

    private static boolean shouldRender(@NotNull ParticleOptions effect) {
        ParticleType type = effect.m_6012_();
        if (whiteList.contains(type)) {
            return true;
        }
        return !blackList.contains(type);
    }

    private static boolean isBlockParticle(Particle p) {
        return p instanceof TerrainParticle || p instanceof FallingDustParticle || p instanceof BlockMarker;
    }

    private static boolean isParticleLooselyInView(Vec3 camPos, Vec3 camLook, double px, double py, double pz, double fovDeg, double padDeg, double aabbPad) {
        double half = Math.toRadians((fovDeg + padDeg) * 0.5);
        double cosThreshold = Math.cos(half);
        if (ParticleRender.isDirWithinCone(camPos, camLook, new Vec3(px, py, pz), cosThreshold)) {
            return true;
        }
        double s = aabbPad;
        double[] xs = new double[]{px - s, px + s};
        double[] ys = new double[]{py - s, py + s};
        double[] zs = new double[]{pz - s, pz + s};
        for (double x : xs) {
            for (double y : ys) {
                for (double z : zs) {
                    if (!ParticleRender.isDirWithinCone(camPos, camLook, new Vec3(x, y, z), cosThreshold)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isDirWithinCone(Vec3 camPos, Vec3 camLook, Vec3 target, double cosThreshold) {
        Vec3 v = target.m_82546_(camPos);
        double len = v.m_82553_();
        if (len < 1.0E-6) {
            return true;
        }
        return camLook.m_82526_(v = v.m_82490_(1.0 / len)) >= cosThreshold;
    }

    static {
        ParticleRender.reloadLists();
    }
}

