/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.entity.EntityUtils;

public class EntityCullRender {
    private static final HashSet<EntityType<?>> blackEntityListCache = new HashSet();
    private static final HashSet<EntityType<?>> whiteEntityListCache = new HashSet();
    private static HashSet<EntityType<?>> blackTagEntityListCache = new HashSet();
    private static HashSet<EntityType<?>> whiteTagEntityListCache = new HashSet();
    private static final Minecraft mc = Minecraft.m_91087_();

    private static void initConfigList() {
        Optional<EntityType<?>> entityTypeOpt;
        List<String> blackConfig = RuOK.get().blackListedEntities;
        List<String> whiteConfig = RuOK.get().whiteListedEntities;
        for (String bc : blackConfig) {
            entityTypeOpt = EntityCullRender.entityTypeGet(bc);
            entityTypeOpt.ifPresent(blackEntityListCache::add);
        }
        for (String wc : whiteConfig) {
            entityTypeOpt = EntityCullRender.entityTypeGet(wc);
            entityTypeOpt.ifPresent(whiteEntityListCache::add);
        }
        blackTagEntityListCache = EntityCullRender.getTagEntity(RuOK.get().BlackTagListEntity);
        whiteTagEntityListCache = EntityCullRender.getTagEntity(RuOK.get().WhiteTagListEntity);
    }

    public static Optional<EntityType<?>> entityTypeGet(String id) {
        return BuiltInRegistries.f_256780_.m_6612_(ResourceLocation.m_135820_((String)id));
    }

    public static HashSet<EntityType<?>> getTagEntity(List<String> list) {
        HashSet entityTypes = new HashSet();
        for (String s : list) {
            TagKey entity = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(s));
            BuiltInRegistries.f_256780_.forEach(type -> {
                if (type.m_204039_(entity)) {
                    entityTypes.add((EntityType<?>)type);
                }
            });
        }
        return entityTypes;
    }

    public static void reloadList() {
        blackEntityListCache.clear();
        whiteEntityListCache.clear();
        blackTagEntityListCache.clear();
        whiteTagEntityListCache.clear();
        EntityCullRender.initConfigList();
    }

    public static boolean isBlacklisted(@NotNull Entity entity) {
        return blackEntityListCache.contains(entity.m_6095_()) || blackTagEntityListCache.contains(entity.m_6095_());
    }

    public static boolean isWhitelisted(@NotNull Entity entity) {
        return whiteEntityListCache.contains(entity.m_6095_()) || whiteTagEntityListCache.contains(entity.m_6095_());
    }

    public static boolean shouldCull(Entity entity, double maxDistance) {
        double maxDistSq;
        if (EntityCullRender.mc.f_91073_ == null || EntityCullRender.mc.f_91074_ == null || entity == EntityCullRender.mc.f_91074_) {
            return false;
        }
        if (EntityCullRender.isBlacklisted(entity)) {
            return true;
        }
        double distSq = entity.m_20280_((Entity)EntityCullRender.mc.f_91074_);
        return distSq > (maxDistSq = maxDistance * maxDistance);
    }

    public static boolean isBossEntity(@NotNull Entity entity) {
        return EntityUtils.BossTags.isCachedBoss(entity);
    }

    static {
        EntityCullRender.initConfigList();
    }
}

