/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util.clazz.jfr;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import jdk.jfr.Recording;
import team.teampotato.ruok.RuOKMod;
import team.teampotato.ruok.util.clazz.jfr.JFRSupportChecker;

public class JFRManager {
    private static boolean recordingActive = false;
    private static Recording recording;
    private static long startTimeNs;

    public static boolean checkAndWarn() {
        boolean supported = JFRSupportChecker.isJFRAvailable();
        if (!supported) {
            RuOKMod.LOGGER.info("[JFR SupportChecker] Flight Recorder is not supported in this environment. Skipping recording startup.");
        }
        return supported;
    }

    public static void start() {
        if (recordingActive) {
            return;
        }
        recording = new Recording();
        if (!JFRManager.checkAndWarn()) {
            return;
        }
        try {
            recording.setName("RuOKProfiling");
            recording.setToDisk(true);
            recording.setDestination(Path.of("ruok_recording.jfr", new String[0]));
            JFRManager.enableEvents(recording);
            recording.start();
            recordingActive = true;
            startTimeNs = System.nanoTime();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start JFR recording", e);
        }
    }

    public static void stop() {
        if (!recordingActive) {
            return;
        }
        try {
            recording.stop();
            recording.close();
            long durationNs = System.nanoTime() - startTimeNs;
            System.out.printf("[JFR] Recording stopped after %.2f seconds%n", (double)durationNs / 1.0E9);
        }
        finally {
            recordingActive = false;
        }
    }

    public static boolean isActive() {
        return recordingActive;
    }

    private static void enableEvents(Recording recording) {
        recording.enable("jdk.ExecutionSample").withThreshold(Duration.ofMillis(20L));
        recording.enable("jdk.ObjectAllocationInNewTLAB").withStackTrace();
        recording.enable("jdk.ObjectAllocationOutsideTLAB").withStackTrace();
        recording.enable("jdk.GarbageCollection");
        recording.enable("jdk.GCHeapSummary");
        recording.enable("jdk.GCPhasePause");
        recording.enable("jdk.GCReferenceStatistics");
        recording.enable("jdk.ThreadSleep");
        recording.enable("jdk.ThreadPark");
        recording.enable("jdk.JavaMonitorEnter");
        recording.enable("jdk.NativeMethodSample");
        recording.enable("jdk.ClassLoadingStatistics");
        recording.enable("jdk.ClassUnload");
        recording.enable("jdk.JavaMonitorWait");
    }

    static {
        startTimeNs = 0L;
    }
}

