/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.util;

import java.util.EnumMap;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.ParticleStatus;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.gui.base.enumText.QualityType;
import team.teampotato.ruok.gui.base.enumText.WeatherType;
import team.teampotato.ruok.util.Options;

public class Quality {
    private static final EnumMap<QualityType, QualitySettings> QUALITY_SETTINGS_MAP = new EnumMap(QualityType.class);

    public static void set(@NotNull QualityType mode) {
        QualitySettings settings = QUALITY_SETTINGS_MAP.get(mode);
        Quality.applySettings(settings);
        RuOK.get().qualityModes = mode;
    }

    private static void applySettings(@NotNull QualitySettings settings) {
        Options.setGraphicsMode(settings.graphicsMode);
        Options.setViewDistance(settings.viewDistance);
        Options.setVsync(settings.vsync);
        Options.setParticles(settings.particlesMode);
        Options.setAo(settings.ao);
        Options.setCloudRenderMode(settings.cloudRenderMode);
        Options.setEntityShadows(settings.entityShadows);
        RuOK.get().MaxEntityEntities = settings.maxEntityEntities;
        RuOK.get().EntityDistance = settings.entitiesDistance;
        RuOK.get().RenderWeather = settings.weather;
        RuOK.get().MaxParticleDistance = settings.maxParticleDistance;
    }

    static {
        QUALITY_SETTINGS_MAP.put(QualityType.ULTRA, new QualitySettings(WeatherType.NORMAL, 16, false, ParticleStatus.ALL, GraphicsStatus.FABULOUS, true, CloudStatus.FANCY, true, 1024, 512, 512));
        QUALITY_SETTINGS_MAP.put(QualityType.HIGH, new QualitySettings(WeatherType.NORMAL, 12, true, ParticleStatus.MINIMAL, GraphicsStatus.FANCY, true, CloudStatus.FANCY, true, 512, 256, 256));
        QUALITY_SETTINGS_MAP.put(QualityType.NORMAL, new QualitySettings(WeatherType.NORMAL, 8, true, ParticleStatus.ALL, GraphicsStatus.FABULOUS, true, CloudStatus.FAST, true, 256, 128, 128));
        QUALITY_SETTINGS_MAP.put(QualityType.LOW, new QualitySettings(WeatherType.LOW, 6, true, ParticleStatus.MINIMAL, GraphicsStatus.FAST, true, CloudStatus.OFF, false, 128, 64, 64));
        QUALITY_SETTINGS_MAP.put(QualityType.CRITICAL, new QualitySettings(WeatherType.CLOSE, 2, true, ParticleStatus.MINIMAL, GraphicsStatus.FAST, false, CloudStatus.OFF, false, 64, 32, 32));
    }

    private record QualitySettings(WeatherType weather, int viewDistance, boolean vsync, ParticleStatus particlesMode, GraphicsStatus graphicsMode, boolean ao, CloudStatus cloudRenderMode, boolean entityShadows, int maxEntityEntities, int entitiesDistance, int maxParticleDistance) {
    }
}

