/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.mixin.minecraft.test;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.ModLoadState;
import team.teampotato.ruok.util.render.EntityRenderUtil;
import team.teampotato.ruok.util.render.compat.IrisCompat;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin
implements ResourceManagerReloadListener {
    @Shadow
    private boolean f_114368_;
    @Shadow
    private boolean f_114369_;
    @Shadow
    private Level f_114366_;

    @Shadow
    public abstract <T extends Entity> EntityRenderer<? super T> m_114382_(T var1);

    @Shadow
    protected abstract void m_114453_(PoseStack var1, MultiBufferSource var2, Entity var3);

    @Shadow
    public abstract double m_114378_(double var1, double var3, double var5);

    @Shadow
    private static void m_114457_(PoseStack matrices, MultiBufferSource vertexConsumers, Entity entity, float opacity, float tickDelta, LevelReader world, float radius) {
    }

    @Shadow
    private static void m_114441_(PoseStack matrices, VertexConsumer vertices, Entity entity, float tickDelta) {
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public <E extends Entity> void render(E entity, double x, double y, double z, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, CallbackInfo ci) {
        if (RuOK.get().EntityPerformance) {
            ci.cancel();
            this.rUOK_1_20_1$performanceRender(entity, x, y, z, yaw, tickDelta, matrices, vertexConsumers, light);
            ci.cancel();
        }
    }

    @Unique
    private <E extends Entity> void rUOK_1_20_1$performanceRender(E entity, double x, double y, double z, float yaw, float tickDelta, @NotNull PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        double distSquared;
        float shadowOpacity;
        EntityRenderer<E> entityRenderer = this.m_114382_(entity);
        Vec3 offset = entityRenderer.m_7860_(entity, tickDelta);
        double dx = x + offset.m_7096_();
        double dy = y + offset.m_7098_();
        double dz = z + offset.m_7094_();
        matrices.m_85836_();
        if (ModLoadState.isIris()) {
            IrisCompat.beginEntityRender(vertexConsumers, entity);
        }
        matrices.m_85837_(dx, dy, dz);
        try {
            entityRenderer.m_7392_(entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
        catch (Throwable ex) {
            EntityRenderUtil.handleRenderException(entity, entityRenderer, x, y, z, yaw, tickDelta, this.f_114366_, ex);
        }
        if (entity.m_6051_()) {
            this.m_114453_(matrices, vertexConsumers, entity);
        }
        if (((Boolean)Minecraft.m_91087_().f_91066_.m_231818_().m_231551_()).booleanValue() && this.f_114368_ && entityRenderer.f_114477_ > 0.0f && !entity.m_20145_() && (shadowOpacity = (float)((1.0 - (distSquared = this.m_114378_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())) / 256.0) * (double)entityRenderer.f_114478_)) > 0.0f) {
            EntityRenderDispatcherMixin.m_114457_(matrices, vertexConsumers, entity, shadowOpacity, tickDelta, (LevelReader)this.f_114366_, Math.min(entityRenderer.f_114477_, 32.0f));
        }
        if (this.f_114369_ && !entity.m_20145_() && !Minecraft.m_91087_().m_91299_()) {
            EntityRenderDispatcherMixin.m_114441_(matrices, vertexConsumers.m_6299_(RenderType.m_110504_()), entity, tickDelta);
        }
        if (ModLoadState.isIris()) {
            IrisCompat.endEntityRender();
        }
        matrices.m_85849_();
    }
}

