/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.modern.widget.option;

import net.minecraft.Util;
import net.minecraft.client.InputType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import team.teampotato.ruok.util.ColorUtil;

public abstract class OptionSliderWidget
extends AbstractSliderButton {
    public boolean sliderFocused;

    protected OptionSliderWidget(int x, int y, int width, int height, double value) {
        super(x, y, width, height, CommonComponents.f_237098_, value);
    }

    public boolean isSliderFocused() {
        return this.sliderFocused;
    }

    protected MutableComponent m_5646_() {
        return super.m_5646_();
    }

    public void m_7691_(double mouseX, double mouseY) {
        if (this.isMouseOverSlider(mouseX, mouseY)) {
            super.m_7435_(Minecraft.m_91087_().m_91106_());
        }
    }

    private boolean isMouseOverSlider(double mouseX, double mouseY) {
        int baseY = this.m_252907_() + this.m_93694_() / 2;
        int sliderMinX = this.m_252754_() + this.m_5711_() * 3 / 4 - 8 + 2;
        int sliderMaxX = sliderMinX + (this.m_5711_() / 4 - 10);
        return mouseX >= (double)sliderMinX && mouseX <= (double)sliderMaxX && mouseY >= (double)(baseY - 3) && mouseY <= (double)(baseY + 3);
    }

    public void m_93692_(boolean focused) {
        super.m_93692_(focused);
        if (!focused) {
            this.sliderFocused = false;
        } else {
            InputType guiNavigationType = Minecraft.m_91087_().m_264529_();
            if (guiNavigationType == InputType.MOUSE || guiNavigationType == InputType.KEYBOARD_TAB) {
                this.sliderFocused = true;
            }
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (CommonInputs.m_278691_((int)keyCode)) {
            this.sliderFocused = !this.sliderFocused;
            return true;
        }
        if (this.sliderFocused) {
            boolean br;
            int left = 263;
            int right = 262;
            boolean bl = keyCode == left;
            boolean bl2 = br = keyCode == right;
            if (bl || br) {
                float f = bl ? -1.0f : 1.0f;
                int sliderMinX = this.m_252754_() + this.m_5711_() * 3 / 4 - 8 + 2;
                int sliderMaxX = sliderMinX + (this.m_5711_() / 4 - 10);
                int sliderWidth = sliderMaxX - sliderMinX;
                this.setValue(this.f_93577_ + (double)(f / (float)sliderWidth));
                return true;
            }
        }
        return false;
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isMouseOverSlider(mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMouseOverSlider(mouseX, mouseY)) {
            this.setValueFromMouse(mouseX);
            return true;
        }
        return false;
    }

    public void setValue(double value) {
        double d = this.f_93577_;
        this.f_93577_ = Mth.m_14008_((double)value, (double)0.0, (double)1.0);
        if (d != this.f_93577_) {
            this.m_5697_();
        }
        this.m_5695_();
    }

    public void setValueFromMouse(double mouseX) {
        int sliderMinX = this.m_252754_() + this.m_5711_() * 3 / 4 - 8 + 2;
        int sliderMaxX = sliderMinX + (this.m_5711_() / 4 - 10);
        int sliderWidth = sliderMaxX - sliderMinX;
        this.setValue((mouseX - (double)sliderMinX) / (double)sliderWidth);
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int alphaValue = Mth.m_14167_((float)(this.f_93625_ * 255.0f));
        Minecraft mc = Minecraft.m_91087_();
        int baseY = 3;
        int endY = this.m_252907_() + this.m_93694_();
        int endX = this.m_252754_() + this.m_5711_();
        int le = 4;
        int boxWidth = (endX - this.m_252754_()) / 4 - le;
        int bY = this.m_252907_() + this.m_93694_() / 2;
        this.renderBackground(context);
        int bX = this.m_252754_() + this.m_5711_() * 3 / 4 - le - 3;
        int boxRight = bX + boxWidth;
        context.m_280509_(bX + 1 - 3, bY + baseY, boxRight - 1 - 3, bY + baseY + 1, -11163051);
        context.m_280509_(bX + 1 - 3, bY - baseY, boxRight - 1 - 3, bY - baseY - 1, -11163051);
        context.m_280509_(bX - 3, bY - baseY, bX + 1 - 3, bY + baseY, -11163051);
        context.m_280509_(boxRight - 3, bY - baseY, boxRight - 1 - 3, bY + baseY, -11163051);
        int sliderWidth = boxWidth - 10;
        int sliderMinX = bX + 2 - 3;
        int sliderMaxX = boxRight - 8 - 3;
        int sliderX = sliderMinX + (int)(this.f_93577_ * (double)sliderWidth);
        sliderX = Mth.m_14045_((int)sliderX, (int)sliderMinX, (int)sliderMaxX);
        int sliderColor = this.m_274382_() ? -5570646 : -7798904;
        context.m_280509_(sliderX, bY - baseY + 1, sliderX + 6, bY + baseY - 1, sliderColor);
        int textColor = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        this.m_280372_(context, mc.f_91062_, 2, textColor | alphaValue << 24);
    }

    public void m_280372_(GuiGraphics context, Font textRenderer, int xMargin, int color) {
        int left = this.m_252754_() + xMargin + 5;
        int right = this.m_252754_() + this.m_5711_() - xMargin;
        OptionSliderWidget.drawScrollableText(context, textRenderer, this.m_6035_(), left, this.m_252907_(), right, this.m_252907_() + this.m_93694_(), color);
    }

    public static void drawScrollableText(GuiGraphics context, Font textRenderer, Component text, int left, int top, int right, int bottom, int color) {
        int textWidth = textRenderer.m_92852_((FormattedText)text);
        int textHeight = 9;
        int centerY = (top + bottom - textHeight) / 2 + 1;
        int maxWidth = right - left;
        if (textWidth > maxWidth) {
            int overflowWidth = textWidth - maxWidth;
            double time = (double)Util.m_137550_() / 1000.0;
            double scrollSpeed = Math.max((double)overflowWidth * 0.5, 3.0);
            double scrollFactor = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * time / scrollSpeed)) / 2.0 + 0.5;
            double scrollX = Mth.m_14139_((double)scrollFactor, (double)0.0, (double)overflowWidth);
            context.m_280588_(left, top, right, bottom);
            context.m_280430_(textRenderer, text, left - (int)scrollX, centerY, color);
            context.m_280618_();
        } else {
            context.m_280430_(textRenderer, text, left, centerY, color);
        }
    }

    public void renderBackground(GuiGraphics context) {
        int color = this.m_198029_() ? ColorUtil.getAUIColor(-804253680, 0.8) : ColorUtil.getAUIColor(-804253680, 0.5);
        context.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), color);
    }
}

