/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.modern.widget.list;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.teampotato.ruok.gui.modern.option.ModernOption;

public class OptionListWidget
extends ContainerObjectSelectionList<WidgetEntry> {
    public int rowLeft;
    public int rowWidth;
    @Nullable
    public WidgetEntry hoveredEntry;

    public OptionListWidget(Minecraft minecraftClient, int width, int height, int y, int y2, int itemHeight, int rowLeft) {
        super(minecraftClient, width, height, y, y2, itemHeight);
        this.rowLeft = rowLeft;
        this.m_93488_(false);
        this.m_93473_(false, 0);
        this.m_93496_(false);
    }

    public void addOptionEntry(AbstractWidget option) {
        this.m_7085_((AbstractSelectionList.Entry)WidgetEntry.create(option));
    }

    public void addAll(List<AbstractWidget> options) {
        for (AbstractWidget option : options) {
            this.addOptionEntry(option);
        }
    }

    public void addOptionEntry(ModernOption<?> option, int width) {
        this.m_7085_((AbstractSelectionList.Entry)WidgetEntry.create(option, width));
    }

    public void addAll(List<ModernOption<?>> options, int width) {
        for (ModernOption<?> option : options) {
            this.addOptionEntry(option, width);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        WidgetEntry entry = (WidgetEntry)this.m_93412_(mouseX, mouseY);
        if (entry != null && entry.m_6375_(mouseX, mouseY, button)) {
            WidgetEntry entry2 = (WidgetEntry)this.m_7222_();
            if (entry2 != entry && entry2 != null) {
                entry2.m_7522_(null);
            }
            this.m_7522_((GuiEventListener)entry);
            this.m_7897_(true);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (amount != 0.0) {
            this.m_93410_(this.m_93517_() - amount * (double)this.f_93387_ / 2.0);
            return true;
        }
        return false;
    }

    protected int m_7610_(int index) {
        return super.m_7610_(index);
    }

    protected int m_93485_(int index) {
        return super.m_93485_(index);
    }

    public void m_93507_(int left) {
        super.m_93507_(left);
    }

    public int m_5747_() {
        return this.rowLeft;
    }

    public void setRowLeft(int rowLeft) {
        this.rowLeft = rowLeft;
    }

    protected void m_238964_(GuiGraphics context, int mouseX, int mouseY, float delta, int index, int x, int y, int entryWidth, int entryHeight) {
        WidgetEntry entry = (WidgetEntry)this.m_93500_(index);
        entry.m_274437_(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, Objects.equals((Object)this.getHoveredEntry(), (Object)entry), delta);
        entry.m_6311_(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, Objects.equals((Object)this.getHoveredEntry(), (Object)entry), delta);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return this.m_93696_() ? NarratableEntry.NarrationPriority.FOCUSED : this.getTypes();
    }

    @NotNull
    private NarratableEntry.NarrationPriority getTypes() {
        if (this.m_93696_()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hoveredEntry != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    @Nullable
    public WidgetEntry getHoveredEntry() {
        return this.hoveredEntry;
    }

    public int m_93520_() {
        return super.m_93520_();
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int i = this.m_5756_();
        int j = i + 4;
        this.hoveredEntry = this.m_5953_(mouseX, mouseY) ? (WidgetEntry)this.m_93412_(mouseX, mouseY) : null;
        this.m_280310_(context);
        this.m_239227_(context, mouseX, mouseY, delta);
        context.m_280618_();
        int m = this.m_93518_();
        if (m > 0) {
            int maxScrollY;
            int n = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
            n = Mth.m_14045_((int)n, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
            int yOffset = 2;
            int o = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - n) / m + this.f_93390_ + yOffset;
            if (o > (maxScrollY = this.f_93391_ - n - yOffset)) {
                o = maxScrollY;
            }
            int borderColor = -1599427926;
            context.m_280509_(i - 1, this.f_93390_ + yOffset, i, this.f_93391_ + yOffset - 2, borderColor);
            context.m_280509_(j, this.f_93390_ + yOffset, j + 1, this.f_93391_ + yOffset - 2, borderColor);
            context.m_280509_(i - 1, this.f_93390_ + yOffset, j + 1, this.f_93390_ + 1 + yOffset, borderColor);
            context.m_280509_(i - 1, this.f_93391_ - 3 + yOffset, j + 1, this.f_93391_ - 1 + yOffset, borderColor);
            int trackX = i + 1;
            context.m_280509_(trackX, o + 2, trackX + 2, o + n, -7798904);
        }
        this.m_7154_(context, mouseX, mouseY);
        RenderSystem.disableBlend();
    }

    protected int m_5756_() {
        return this.f_93392_ - 10;
    }

    protected void m_280310_(GuiGraphics context) {
        context.m_280588_(this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_);
    }

    public void setX1(int x1) {
        this.f_93393_ = x1;
    }

    public void setY1(int y1) {
        this.f_93390_ = y1;
    }

    public void setX2(int x1) {
        this.f_93392_ = x1;
    }

    public void setY2(int y2) {
        this.f_93391_ = y2;
    }

    protected int m_5775_() {
        return super.m_5775_();
    }

    public int m_5759_() {
        return this.rowWidth;
    }

    public void setRowWidth(int rowWidth) {
        this.rowWidth = rowWidth;
    }

    protected static class WidgetEntry
    extends ContainerObjectSelectionList.Entry<WidgetEntry> {
        final List<AbstractWidget> widgets;

        public WidgetEntry(Map<ModernOption<?>, AbstractWidget> widgetMap) {
            this.widgets = ImmutableList.copyOf(widgetMap.values());
        }

        public WidgetEntry(List<AbstractWidget> widgets) {
            this.widgets = widgets;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.widgets;
        }

        public static WidgetEntry create(ModernOption<?> option, int width) {
            AbstractWidget widget = option.createWidget(10, 10, width);
            return new WidgetEntry((Map<ModernOption<?>, AbstractWidget>)ImmutableMap.of(option, (Object)widget));
        }

        public static WidgetEntry create(AbstractWidget widget) {
            return new WidgetEntry(List.of(widget));
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }

        public void m_6311_(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int yaw = y;
            for (AbstractWidget widget : this.widgets) {
                widget.m_253211_(yaw);
                widget.m_252865_(x);
                widget.m_88315_(context, mouseX, mouseY, tickDelta);
                yaw += widget.m_93694_() + 15;
            }
        }
    }
}

