/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.modern.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ButtonWidget
extends AbstractButton {
    protected static final NarrationSupplier DEFAULT_NARRATION_SUPPLIER = Supplier::get;
    protected final PressAction onPress;
    protected final NarrationSupplier narrationSupplier;
    private int lineEndX = 0;

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static Builder builder(Component message, PressAction onPress) {
        return new Builder(message, onPress);
    }

    public ButtonWidget(int x, int y, int width, int height, Component message, PressAction onPress, NarrationSupplier narrationSupplier) {
        super(x, y, width, height, message);
        this.onPress = onPress;
        this.narrationSupplier = narrationSupplier;
    }

    public void m_5691_() {
        this.onPress.onPress(this);
    }

    public boolean m_198029_() {
        return super.m_198029_();
    }

    public void m_168797_(NarrationElementOutput builder) {
        this.m_168802_(builder);
    }

    protected void m_87963_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Minecraft minecraftClient = Minecraft.m_91087_();
        context.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        int alphaValue = Mth.m_14167_((float)(this.f_93625_ * 255.0f));
        if (this.m_274382_()) {
            context.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), alphaValue << 24 | 0xBBBBBB);
        }
        int speed = 30;
        this.lineEndX = this.m_274382_() ? Math.min(this.m_252754_() + this.m_5711_(), this.lineEndX + (int)(delta * (float)speed)) : Math.max(this.m_252754_(), this.lineEndX - (int)(delta * (float)speed));
        if (this.m_274382_()) {
            context.m_285844_(RenderType.m_286086_(), this.m_252754_(), this.lineEndX - 1, this.m_252907_() + this.m_93694_(), -1);
        }
        context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int textColor = this.f_93623_ ? 0xFFFFFF : 0x808080;
        this.m_280139_(context, minecraftClient.f_91062_, textColor);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public static class Builder {
        private final Component message;
        private final PressAction onPress;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 15;
        private NarrationSupplier narrationSupplier = DEFAULT_NARRATION_SUPPLIER;

        public Builder(Component message, PressAction onPress) {
            this.message = message;
            this.onPress = onPress;
        }

        public Builder position(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder dimensions(int x, int y, int width, int height) {
            return this.position(x, y).size(width, height);
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder narrationSupplier(NarrationSupplier narrationSupplier) {
            this.narrationSupplier = narrationSupplier;
            return this;
        }

        public ButtonWidget build() {
            ButtonWidget buttonWidget = new ButtonWidget(this.x, this.y, this.width, this.height, this.message, this.onPress, this.narrationSupplier);
            buttonWidget.m_257544_(this.tooltip);
            return buttonWidget;
        }
    }

    public static interface PressAction {
        public void onPress(ButtonWidget var1);
    }

    public static interface NarrationSupplier {
        public MutableComponent createNarrationMessage(Supplier<MutableComponent> var1);
    }
}

