/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.modern.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import team.teampotato.ruok.RuOKMod;
import team.teampotato.ruok.gui.base.Base;
import team.teampotato.ruok.gui.base.BaseUtil;
import team.teampotato.ruok.gui.base.OptionManager;
import team.teampotato.ruok.gui.base.RuOKGameOptions;
import team.teampotato.ruok.gui.base.enumText.BaseText;
import team.teampotato.ruok.gui.modern.option.ModernOption;

public class ModernOptionsStorage {
    private static final List<ModernOption<?>> main = new ArrayList();
    private static final List<ModernOption<?>> other = new ArrayList();
    private static final List<ModernOption<?>> hud = new ArrayList();
    private static final RuOKGameOptions options = new RuOKGameOptions();

    public static List<ModernOption<?>> getMainOptions() {
        if (main.isEmpty()) {
            ModernOptionsStorage.populateOptions(main, BaseUtil.Group.MAIN);
        }
        return main;
    }

    public static List<ModernOption<?>> getOtherOptions() {
        if (other.isEmpty()) {
            ModernOptionsStorage.populateOptions(other, BaseUtil.Group.OTHER);
        }
        return other;
    }

    public static List<ModernOption<?>> getHudOptions() {
        if (hud.isEmpty()) {
            ModernOptionsStorage.populateOptions(hud, BaseUtil.Group.HUD);
        }
        return hud;
    }

    private static void populateOptions(List<ModernOption<?>> targetList, BaseUtil.Group group) {
        List<Base> filteredBases = OptionManager.getBinds().stream().filter(base -> base.group == group).toList();
        filteredBases.forEach(base -> {
            if (BaseUtil.isBoolean(base)) {
                targetList.add(ModernOptionsStorage.ofBoolean(base));
            } else if (BaseUtil.isInteger(base)) {
                targetList.add(ModernOptionsStorage.ofInteger(base));
            } else if (BaseUtil.isEnum(base)) {
                targetList.add(ModernOptionsStorage.ofEnum(base));
            } else {
                RuOKMod.LOGGER.warn("Error BaseData: {}", (Object)base.getImplClass().getName());
            }
        });
    }

    private static ModernOption<Integer> ofInteger(Base<RuOKGameOptions, Integer> base) {
        return new ModernOption<Integer>(base.key + ".info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)(base.key + ".tooltip")).m_7220_((Component)BaseUtil.getTextAndNewLine(base.compatibilityLevel, base.optimizeLevel, base.performanceLevel))), (optionText, value) -> Options.m_231921_((Component)optionText, (Component)Component.m_237110_((String)base.format, (Object[])new Object[]{value})), new ModernOption.ValidatingIntSliderCallbacks(base.min, base.max), (Integer)base.function.apply(options), intValue -> base.biConsumer.accept(options, (RuOKGameOptions)((Object)intValue)));
    }

    private static ModernOption<Boolean> ofBoolean(Base<RuOKGameOptions, Boolean> base) {
        return ModernOption.ofBoolean(base.key + ".info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)(base.key + ".tooltip")).m_7220_((Component)BaseUtil.getTextAndNewLine(base.compatibilityLevel, base.optimizeLevel, base.performanceLevel))), (Boolean)base.function.apply(options), bool -> base.biConsumer.accept(options, (RuOKGameOptions)((Object)bool)));
    }

    public static <T extends Enum<T>> ModernOption<T> ofEnum(Base<RuOKGameOptions, ?> rawBase) {
        Base<RuOKGameOptions, ?> base = rawBase;
        Class enumClass = base.getEnumClass();
        List<Enum> values = Arrays.asList((Enum[])enumClass.getEnumConstants());
        return new ModernOption<Enum>(base.key + ".info", value -> Tooltip.m_257550_((Component)Component.m_237115_((String)(base.key + ".tooltip")).m_7220_((Component)BaseUtil.getTextAndNewLine(base.compatibilityLevel, base.optimizeLevel, base.performanceLevel))), (optionText, value) -> ((BaseText)((Object)value)).getTextOrEmpty(), new ModernOption.AlternateValuesSupportingCyclingCallbacks<Enum>(values, values, () -> true, (option, mode) -> {
            option.setValue(mode);
            base.biConsumer.accept(options, (RuOKGameOptions)((Object)mode));
        }), (Enum)base.function.apply(options), value -> base.biConsumer.accept(options, (RuOKGameOptions)((Object)value)));
    }
}

