/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.modern.screens;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.util.entity.EntityCullRender;
import team.teampotato.ruok.util.particle.ParticleRender;

public class EntityListScreen
extends Screen {
    private EntityListWidget list;
    private EditBox textField;
    private final List<String> lists;
    public static Collection<EntityType<?>> entityTypes = BuiltInRegistries.f_256780_.m_123024_().toList();
    public static EntityType<?>[] types = entityTypes.toArray(new EntityType[0]);
    public final Screen parent;

    public EntityListScreen(Component title, Screen parent, List<String> list) {
        super(title);
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.lists = list;
        this.parent = parent;
    }

    protected void m_7856_() {
        this.list = new EntityListWidget(this, this.lists);
        this.m_7787_((GuiEventListener)this.list);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, v -> {
            if (this.f_96541_ != null) {
                ParticleRender.reloadLists();
                this.f_96541_.m_91152_(this.parent);
            }
        }).m_252987_(Minecraft.m_91087_().m_91268_().m_85445_() / 2, this.f_96544_ - 29, 150, 20).m_253136_());
        this.textField = this.getTextField();
    }

    private EditBox getTextField() {
        return (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 155, this.f_96544_ - 29, 150, 20, (Component)Component.m_237119_()));
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.list.m_88315_(context, mouseX, mouseY, delta);
        context.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_86600_() {
        String fieldText = this.textField.m_94155_().toLowerCase();
        this.list.m_6702_().clear();
        ArrayList addedEntries = new ArrayList();
        for (EntityType<?> type : types) {
            EntityListWidget.TypeEntry entry;
            String trID = type.m_20676_().getString();
            String id = Objects.requireNonNull(BuiltInRegistries.f_256780_.m_7981_(type)).toString();
            if ((fieldText.isEmpty() || trID.contains(fieldText)) && !addedEntries.contains(type)) {
                entry = this.list.createEntry(type);
                this.list.add(entry);
                addedEntries.add(type);
            }
            if (!fieldText.isEmpty() && !id.contains(fieldText) || addedEntries.contains(type)) continue;
            entry = this.list.createEntry(type);
            this.list.add(entry);
            addedEntries.add(type);
        }
    }

    static class EntityListWidget
    extends ContainerObjectSelectionList<TypeEntry> {
        public static Minecraft client = Minecraft.m_91087_();
        private final List<String> list;

        public EntityListWidget(@NotNull EntityListScreen bls, List<String> list) {
            super(client, bls.f_96543_, bls.f_96544_, 20, bls.f_96544_ - 32, 20);
            this.list = list;
        }

        public TypeEntry createEntry(EntityType<?> type) {
            return new TypeEntry(type, this.list);
        }

        public void add(TypeEntry typeEntry) {
            this.m_7085_((AbstractSelectionList.Entry)typeEntry);
        }

        public static class TypeEntry
        extends ContainerObjectSelectionList.Entry<TypeEntry> {
            public String name;
            public Minecraft client;
            public EntityType<?> type;
            public AbstractWidget widget;
            public List<String> list;

            public TypeEntry(EntityType<?> type, List<String> list) {
                this.type = type;
                this.client = Minecraft.m_91087_();
                this.list = list;
                this.name = Component.m_237115_((String)this.type.m_20675_()).getString();
                boolean isList = this.list.contains(Objects.requireNonNull(BuiltInRegistries.f_256780_.m_7981_(type)).toString());
                this.widget = OptionInstance.m_231525_((String)(isList ? "ruok.options.gui.enable" : "ruok.options.gui.disable"), (boolean)isList).m_261194_(this.client.f_91066_, 60, 20, 60, this::onRenderButtonClick);
                this.refreshEntry();
            }

            private void onRenderButtonClick(boolean isEnabled) {
                String register = Objects.requireNonNull(BuiltInRegistries.f_256780_.m_7981_(this.type)).toString();
                if (isEnabled) {
                    this.list.add(register);
                } else {
                    this.list.remove(register);
                }
                RuOK.save();
                EntityCullRender.reloadList();
                this.refreshEntry();
            }

            public void refreshEntry() {
                this.widget.m_93666_((Component)(this.list.contains(Objects.requireNonNull(BuiltInRegistries.f_256780_.m_7981_(this.type)).toString()) ? Component.m_237115_((String)"ruok.options.gui.enable") : Component.m_237115_((String)"ruok.options.gui.disable")));
            }

            public void m_6311_(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                int textYPosition = y + entryHeight / 2 - 4;
                context.m_280056_(this.client.f_91062_, this.name, x - 20, textYPosition, 0xFFFFFF, false);
                this.widget.m_252865_(x + 160);
                this.widget.m_253211_(y);
                this.widget.m_88315_(context, mouseX, mouseY, tickDelta);
            }

            public List<? extends GuiEventListener> m_6702_() {
                return ImmutableList.of((Object)this.widget);
            }

            public List<? extends NarratableEntry> m_142437_() {
                return ImmutableList.of((Object)this.widget);
            }
        }
    }
}

