/*
 * Decompiled with CFR 0.152.
 */
package team.teampotato.ruok.gui.modern;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.teampotato.ruok.config.RuOK;
import team.teampotato.ruok.gui.modern.GuiViewType;
import team.teampotato.ruok.gui.modern.option.ModernOption;
import team.teampotato.ruok.gui.modern.screens.ConfigHUDScreen;
import team.teampotato.ruok.gui.modern.screens.DeBugScreen;
import team.teampotato.ruok.gui.modern.screens.EntityListScreen;
import team.teampotato.ruok.gui.modern.screens.ParticleListScreen;
import team.teampotato.ruok.gui.modern.storage.ModernOptionsStorage;
import team.teampotato.ruok.gui.modern.widget.ButtonWidget;
import team.teampotato.ruok.gui.modern.widget.MessageWidget;
import team.teampotato.ruok.gui.modern.widget.list.OptionListWidget;
import team.teampotato.ruok.util.ToastUtil;

public class MainScreen
extends Screen {
    private final Minecraft mc = Minecraft.m_91087_();
    private ButtonWidget currentButton;
    private final Component NORMAL_SETTING_TEXT = Component.m_237115_((String)"ruok.setting.normal");
    private final Component OTHER_SETTING_TEXT = Component.m_237115_((String)"ruok.setting.other");
    private final Component HUD_SETTING_TEXT = Component.m_237115_((String)"ruok.setting.hud");
    private final Component LIST_SETTING_TEXT = Component.m_237115_((String)"ruok.setting.list");
    private final Component HUD_CONFIG_TEXT = Component.m_237115_((String)"ruok.config.hud");
    private final Component DEBUG_HUD_TEXT = Component.m_237115_((String)"ruok.setting.debug");
    private int ButtEndX = 0;
    public List<ButtonWidget> buttonWidgets = Lists.newArrayList();
    @Nullable
    public List<ModernOption<?>> currentOptionList = this.getDefaultList();
    private int oopsButtonCount = 0;
    private final Screen parent;
    private boolean onOptionList = false;
    public int EndHeadY;
    public final Component WHITE_ENTITY_TEXT = Component.m_237115_((String)"ruok.options.gui.white.entity");
    public final Component BLACK_ENTITY_TEXT = Component.m_237115_((String)"ruok.options.gui.black.entity");
    public final Component WHITE_PARTICLE_TEXT = Component.m_237115_((String)"ruok.options.gui.white.particle");
    public final Component BLACK_PARTICLE_TEXT = Component.m_237115_((String)"ruok.options.gui.black.particle");

    public MainScreen(Component title, Screen parent) {
        super(title);
        this.parent = parent;
    }

    public List<AbstractWidget> getSettingList() {
        int baseX = this.ButtEndX + 3 + 1;
        int listWidth = this.f_96543_ - baseX;
        ArrayList clickableWidgets = Lists.newArrayList();
        int baseWidth = this.f_96543_ - this.ButtEndX;
        int buttonWidth = baseWidth - 20;
        MessageWidget messageWidget = new MessageWidget(baseX, baseX + listWidth, buttonWidth, 20, (Component)Component.m_237115_((String)"ruok.options.gui.view.type.info"));
        ButtonWidget setModeWidget = ButtonWidget.builder((Component)Component.m_237115_((String)"ruok.options.gui.view.type.ordinary"), e -> {
            RuOK.get().GuiViewMode = GuiViewType.ORDINARY;
            RuOK.save();
            if (RuOK.get().DeBug) {
                ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.title"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.info"));
            } else {
                ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.selection.done"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.toast.ordinary"));
            }
            this.initLeftButton();
            this.m_232761_();
        }).build();
        ButtonWidget setModeWidgets = ButtonWidget.builder((Component)Component.m_237115_((String)"ruok.options.gui.view.type.technical"), e -> {
            RuOK.get().GuiViewMode = GuiViewType.TECHNICAL;
            RuOK.get().DeBug = true;
            RuOK.save();
            ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.selection.done"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.toast.technical"));
            this.initLeftButton();
            this.m_232761_();
        }).build();
        messageWidget.m_93674_(baseWidth);
        setModeWidget.m_93674_(baseWidth);
        setModeWidget.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.options.gui.view.type.ordinary.tooltip")));
        setModeWidgets.m_93674_(baseWidth);
        setModeWidgets.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.options.gui.view.type.technical.tooltip")));
        clickableWidgets.add(messageWidget);
        clickableWidgets.add(setModeWidget);
        clickableWidgets.add(setModeWidgets);
        return clickableWidgets;
    }

    public List<ModernOption<?>> getDefaultList() {
        return ModernOptionsStorage.getMainOptions();
    }

    protected void m_7856_() {
        this.initLeftButton();
        super.m_7856_();
        this.addLeftButton(this.buttonWidgets);
        this.addRightButton(this.currentOptionList);
        this.m_142416_((GuiEventListener)this.getRightDoneButton());
    }

    public AbstractWidget getRightDoneButton() {
        ButtonWidget.Builder clickableWidget = ButtonWidget.builder(CommonComponents.f_130655_, e -> this.mc.m_91152_(this.parent));
        clickableWidget.dimensions(this.f_96543_ - 110, this.f_96544_ - 23, 100, 15);
        return clickableWidget.build();
    }

    public void renderLeftDoneButton(AbstractWidget widget, GuiGraphics context) {
        int color = -804253680;
        int width = widget.m_5711_();
        int height = widget.m_93694_();
        int bX = widget.m_252754_();
        int bY = widget.m_252907_();
        context.m_280509_(bX, bY, bX + width, bY + height, color);
    }

    private void initLeftButton() {
        if (this.buttonWidgets.isEmpty()) {
            this.buttonWidgets = this.getLeftButton();
        }
    }

    public void m_280273_(GuiGraphics context) {
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderLeftBackground(context, (Component)Component.m_237115_((String)"ruok.options.gui.ruok"));
        this.renderRightBackground(context);
        this.renderCurrentButton(context);
        this.renderLeftDoneButton(this.getRightDoneButton(), context);
        this.renderLeftDownText(context);
        super.m_88315_(context, mouseX, mouseY, delta);
    }

    public void renderLeftDownText(GuiGraphics context) {
        int startX = 0;
        int endX = this.ButtEndX;
        int startY = this.f_96544_ - 50;
        int endY = this.f_96544_;
        context.m_285844_(RenderType.m_286086_(), startX, endX, startY, -1);
        Component playerName = this.mc.f_91074_ != null ? this.mc.f_91074_.m_7755_() : Component.m_130674_((String)this.mc.m_91094_().m_92546_());
        MutableComponent text = Component.m_237110_((String)"ruok.options.gui.left.down.text.player", (Object[])new Object[]{playerName});
        context.m_280614_(this.f_96547_, (Component)text, startX + 5, startY + 5, 0xFFFFFF, false);
        context.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"ruok.options.gui.left.down.text.ruok", (Object[])new Object[]{"1.7.2"}), startX + 5, endY - 15, 0xAAAAAA, false);
    }

    private void renderCurrentButton(GuiGraphics context) {
        if (RuOK.get().GuiViewMode.equals((Object)GuiViewType.EMPTY)) {
            return;
        }
        if (this.getCurrentButton() != null) {
            int startY = this.getCurrentButton().m_252907_();
            int EndY = this.getCurrentButton().m_252907_() + this.getCurrentButton().m_93694_();
            int startX = this.getCurrentButton().m_252754_();
            context.m_285886_(RenderType.m_286086_(), startX, startY, EndY, -1);
        }
    }

    private void oopsButton() {
        if (this.oopsButtonCount == 1) {
            ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.title"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.info.1"));
        }
        if (this.oopsButtonCount == 10) {
            ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.title"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.info.2"));
        }
        if (this.oopsButtonCount == 100) {
            ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.title"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.info.3"));
        }
        if (this.oopsButtonCount == 500) {
            ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.title"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.info.4"));
        }
        if (this.oopsButtonCount == 1000) {
            ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.title"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.info.5"));
        }
        if (this.oopsButtonCount == 2000) {
            ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.title"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.info.6"));
        }
        if (this.oopsButtonCount == 2005) {
            ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.title"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.info.7"));
            for (ButtonWidget buttonWidget : this.buttonWidgets) {
                this.m_169411_((GuiEventListener)buttonWidget);
            }
        }
        ++this.oopsButtonCount;
    }

    public void setCurrentButton(ButtonWidget currentButton) {
        this.currentButton = currentButton;
    }

    public void setCurrentOptionList(@Nullable List<ModernOption<?>> currentOptionList) {
        this.currentOptionList = currentOptionList;
    }

    public void setSelectableOption(List<ModernOption<?>> options, ButtonWidget buttonWidget) {
        this.onOptionList = false;
        if (RuOK.get().GuiViewMode.equals((Object)GuiViewType.EMPTY)) {
            this.oopsButton();
        } else {
            if (this.oopsButtonCount > 10) {
                ToastUtil.send((Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.done.title"), (Component)Component.m_237115_((String)"ruok.options.gui.view.type.oops.button.done.info"));
                this.oopsButtonCount = 0;
            }
            this.setCurrentOptionList(options);
            this.m_232761_();
            this.setCurrentButton(buttonWidget);
        }
    }

    public ButtonWidget getCurrentButton() {
        return this.currentButton;
    }

    public List<ButtonWidget> getLeftButton() {
        ArrayList<ButtonWidget> buttonWidgets = new ArrayList<ButtonWidget>();
        buttonWidgets.add(ButtonWidget.builder(this.NORMAL_SETTING_TEXT, e -> this.setSelectableOption(ModernOptionsStorage.getMainOptions(), e)).build());
        buttonWidgets.add(ButtonWidget.builder(this.OTHER_SETTING_TEXT, e -> this.setSelectableOption(ModernOptionsStorage.getOtherOptions(), e)).build());
        buttonWidgets.add(ButtonWidget.builder(this.HUD_SETTING_TEXT, e -> this.setSelectableOption(ModernOptionsStorage.getHudOptions(), e)).build());
        buttonWidgets.add(ButtonWidget.builder(this.LIST_SETTING_TEXT, e -> {
            this.onOptionList = true;
            this.m_232761_();
            this.setCurrentButton(e);
        }).build());
        buttonWidgets.add(ButtonWidget.builder(this.HUD_CONFIG_TEXT, e -> {
            this.mc.m_91152_((Screen)new ConfigHUDScreen(this.HUD_CONFIG_TEXT, this));
            this.m_232761_();
            this.onOptionList = false;
        }).build());
        if (RuOK.get().DeBug) {
            buttonWidgets.add(ButtonWidget.builder(this.DEBUG_HUD_TEXT, e -> {
                this.mc.m_91152_((Screen)new DeBugScreen(this, this.DEBUG_HUD_TEXT));
                this.m_232761_();
                this.setCurrentButton(e);
                this.onOptionList = false;
            }).build());
        }
        return buttonWidgets;
    }

    public void renderLeftBackground(GuiGraphics context, Component title) {
        int yOffset;
        int color = -804253680;
        int height = context.m_280206_();
        if (this.mc.f_91073_ == null) {
            this.m_280039_(context);
        }
        int containerX = 20;
        int containerY = 40;
        int containerWidth = 100;
        context.m_280509_(0, 0, containerX + containerWidth, height, color);
        this.drawCenteredText(context, title, containerX - 15, 5, 1.5f);
        this.ButtEndX = containerX + containerWidth;
        this.EndHeadY = yOffset = containerY / 2 + 20;
        context.m_285844_(RenderType.m_286086_(), 0, this.ButtEndX, yOffset - 13, -1);
        context.m_285844_(RenderType.m_286086_(), this.ButtEndX, context.m_280182_(), yOffset - 13, -1);
    }

    public void addLeftButton(List<ButtonWidget> list) {
        int yOffset;
        int containerX = 20;
        int containerY = 40;
        int containerWidth = 100;
        this.ButtEndX = containerX + containerWidth;
        this.EndHeadY = yOffset = containerY / 2 + 20;
        int wid = containerX + containerWidth;
        for (ButtonWidget widget : list) {
            widget.m_93674_(wid);
            widget.m_252865_(0);
            widget.m_253211_(yOffset - 8);
            this.m_142416_((GuiEventListener)widget);
            yOffset += 18;
        }
    }

    public void renderRightBackground(GuiGraphics context) {
        int color = -804253680;
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        int newAlpha = (int)((double)alpha * 0.7);
        int newColor = newAlpha << 24 | red << 16 | green << 8 | blue;
        context.m_285886_(RenderType.m_286086_(), this.ButtEndX, 0, context.m_280182_(), -1);
        context.m_280509_(this.ButtEndX, 0, context.m_280182_(), this.f_96544_, newColor);
    }

    public void addRightButton(List<ModernOption<?>> list) {
        int baseX = this.ButtEndX + 3 + 1;
        int baseY = this.EndHeadY - 12;
        int listWidth = this.f_96543_ - baseX;
        int listHeight = this.f_96544_ - baseY;
        int rq = this.f_96543_ - this.ButtEndX;
        int rowLeft = baseX + 20;
        OptionListWidget lists = new OptionListWidget(this.mc, listWidth, listHeight, baseY, this.f_96544_ - 20, 20, rowLeft);
        lists.setRowLeft(this.ButtEndX + 1);
        lists.setRowWidth(rq);
        lists.setX1(this.ButtEndX + 1);
        lists.setX2(baseX + listWidth);
        lists.setY1(baseY);
        lists.setY2(this.f_96544_ - 30);
        if (RuOK.get().GuiViewMode.equals((Object)GuiViewType.EMPTY)) {
            lists.addAll(this.getSettingList());
        } else if (this.onOptionList) {
            lists.addAll(this.getOptionList());
        } else {
            lists.addAll(list, rq - 20);
        }
        this.m_142416_((GuiEventListener)lists);
    }

    public List<AbstractWidget> getOptionList() {
        int baseX = this.ButtEndX + 3 + 1;
        int listWidth = this.f_96543_ - baseX;
        int baseWidth = this.f_96543_ - this.ButtEndX;
        int buttonWidth = baseWidth - 20;
        ArrayList widgets = Lists.newArrayList();
        MessageWidget messageWidget = new MessageWidget(baseX, baseX + listWidth, buttonWidth, 20, (Component)Component.m_237115_((String)"ruok.options.gui.list.info"));
        ButtonWidget whiteParticle = ButtonWidget.builder(this.WHITE_PARTICLE_TEXT, e -> this.mc.m_91152_((Screen)new ParticleListScreen(this.WHITE_PARTICLE_TEXT, this, RuOK.get().WhiteListedParticle))).size(baseWidth, 20).build();
        ButtonWidget blackParticle = ButtonWidget.builder(this.BLACK_PARTICLE_TEXT, e -> this.mc.m_91152_((Screen)new ParticleListScreen(this.BLACK_PARTICLE_TEXT, this, RuOK.get().BlackListedParticle))).size(baseWidth, 20).build();
        ButtonWidget whiteEntity = ButtonWidget.builder(this.WHITE_ENTITY_TEXT, e -> this.mc.m_91152_((Screen)new EntityListScreen(this.WHITE_ENTITY_TEXT, this, RuOK.get().whiteListedEntities))).size(baseWidth, 20).build();
        ButtonWidget blackEntity = ButtonWidget.builder(this.BLACK_ENTITY_TEXT, e -> this.mc.m_91152_((Screen)new EntityListScreen(this.BLACK_ENTITY_TEXT, this, RuOK.get().blackListedEntities))).size(baseWidth, 20).build();
        messageWidget.m_93674_(baseWidth);
        whiteParticle.m_93674_(baseWidth);
        whiteParticle.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.options.gui.list.particle.white")));
        blackParticle.m_93674_(baseWidth);
        blackParticle.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.options.gui.list.particle.black")));
        whiteEntity.m_93674_(baseWidth);
        whiteEntity.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.options.gui.list.entity.white")));
        blackEntity.m_93674_(baseWidth);
        blackEntity.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ruok.options.gui.list.entity.black")));
        widgets.add(messageWidget);
        widgets.add(whiteParticle);
        widgets.add(blackParticle);
        widgets.add(whiteEntity);
        widgets.add(blackEntity);
        return widgets;
    }

    protected void m_232761_() {
        this.m_169413_();
        this.blur();
        this.m_7856_();
    }

    protected void m_267719_() {
        super.m_267719_();
    }

    private void blur() {
        ComponentPath guiNavigationPath = this.m_264435_();
        if (guiNavigationPath != null) {
            guiNavigationPath.m_264432_(false);
        }
    }

    private void drawCenteredText(@NotNull GuiGraphics context, Component text, int x, int y, float scale) {
        PoseStack matrixStack = context.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_85841_(scale, scale, 1.0f);
        context.m_280614_(this.mc.f_91062_, text, x, y, 0xFFFFFF, false);
        matrixStack.m_85849_();
    }
}

