/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.mixin;

import com.mojang.blaze3d.platform.InputConstants;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.TooltipRenderer;
import dev.xylonity.tooltipoverhaul.client.wrap.TooltipWrapper;
import dev.xylonity.tooltipoverhaul.mixin.KeyMappingAccessor;
import dev.xylonity.tooltipoverhaul.registry.TooltipOverhaulKeyMappings;
import dev.xylonity.tooltipoverhaul.util.ITooltipOverhaulItemAware;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=1)
public class GuiGraphicsMixin {
    @Inject(method={"renderTooltipInternal"}, at={@At(value="HEAD")}, cancellable=true)
    private void tooltipoverhaul$coreRenderer(Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner tooltipPositioner, CallbackInfo ci) {
        List<ClientTooltipComponent> mainText;
        int sw = Minecraft.m_91087_().m_91268_().m_85445_();
        int sh = Minecraft.m_91087_().m_91268_().m_85446_();
        ItemStack stack = ((ITooltipOverhaulItemAware)((Object)this)).tooltipsOverhaul$hoveredItem();
        boolean isKeyDown = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)((KeyMappingAccessor)TooltipOverhaulKeyMappings.COMPARE_TOOLTIP).tooltipoverhaul$key().m_84873_());
        TooltipContext equippedContext = null;
        if (isKeyDown) {
            equippedContext = this.tooltipoverhaul$getHoveredContext(font, mouseX, mouseY, stack, sw, sh);
        }
        boolean comparisonActive = equippedContext != null;
        boolean isAtMainHalf = false;
        if (comparisonActive) {
            List<ClientTooltipComponent> rebuilt = this.tooltipoverhaul$getTooltipFromStack(stack);
            if (this.tooltipoverhaul$estimateFullWidth(font, rebuilt, !stack.m_41619_()) > sw / 2 - 4) {
                mainText = TooltipWrapper.wrapHalf(font, rebuilt, sw, stack);
                isAtMainHalf = true;
            } else {
                mainText = TooltipWrapper.wrap(font, rebuilt, sw, stack);
            }
        } else {
            mainText = TooltipWrapper.wrap(font, components, sw, stack);
        }
        TooltipContext mainContext = TooltipContext.of((GuiGraphics)this, mouseX, mouseY, sw, sh, mainText, stack, equippedContext, true);
        mainContext.setHalfWrapped(isAtMainHalf);
        if (equippedContext != null) {
            equippedContext.setOtherTooltipContext(mainContext);
        }
        if (TooltipRenderer.render(mainContext)) {
            if (comparisonActive) {
                TooltipRenderer.render(equippedContext);
            }
            ci.cancel();
        }
    }

    @Unique
    private TooltipContext tooltipoverhaul$getHoveredContext(Font font, int mouseX, int mouseY, ItemStack stack, int sw, int sh) {
        ItemStack toCompare = ItemStack.f_41583_;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (stack.m_41619_() || player == null) {
            return null;
        }
        Item item = stack.m_41720_();
        if (item instanceof Equipable) {
            Equipable e = (Equipable)item;
            ItemStack armor = player.m_150109_().m_36052_(e.m_40402_().m_20749_());
            if (!armor.m_41619_()) {
                toCompare = armor;
            }
        }
        if (toCompare.m_41619_() || ItemStack.m_150942_((ItemStack)toCompare, (ItemStack)stack)) {
            return null;
        }
        List<ClientTooltipComponent> compareComponents = this.tooltipoverhaul$getTooltipFromStack(toCompare);
        boolean needsHalf = this.tooltipoverhaul$estimateFullWidth(font, compareComponents, true) > sw / 2 - 4;
        List<ClientTooltipComponent> wrapped = needsHalf ? TooltipWrapper.wrapHalf(font, compareComponents, sw, toCompare) : TooltipWrapper.wrap(font, compareComponents, sw, toCompare);
        TooltipContext ctx = TooltipContext.of((GuiGraphics)this, mouseX, mouseY, sw, sh, wrapped, toCompare, null, false);
        ctx.setHalfWrapped(needsHalf);
        return ctx;
    }

    @Unique
    private List<ClientTooltipComponent> tooltipoverhaul$getTooltipFromStack(ItemStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        ArrayList<ClientTooltipComponent> components = new ArrayList<ClientTooltipComponent>();
        if (player == null || stack.m_41619_()) {
            return components;
        }
        List lines = stack.m_41651_((Player)player, (TooltipFlag)(minecraft.f_91066_.f_92125_ ? TooltipFlag.f_256730_ : TooltipFlag.f_256752_));
        for (Component line : lines) {
            components.add(ClientTooltipComponent.m_169948_((FormattedCharSequence)line.m_7532_()));
        }
        stack.m_150921_().ifPresent(component -> {
            if (component instanceof BundleTooltip) {
                BundleTooltip bundle = (BundleTooltip)component;
                int idx = lines.size() > 1 ? 1 : components.size();
                components.add(idx, ClientTooltipComponent.m_169950_((TooltipComponent)bundle));
            }
        });
        return components;
    }

    @Unique
    private int tooltipoverhaul$estimateFullWidth(Font font, List<ClientTooltipComponent> components, boolean hasIcon) {
        if (components == null || components.isEmpty()) {
            return 0;
        }
        int width = TooltipRenderer.PADDING_X * 2 + (hasIcon ? 26 : 0) + components.get(0).m_142069_(font);
        for (ClientTooltipComponent component : components) {
            width = Math.max(width, TooltipRenderer.PADDING_X * 2 + component.m_142069_(font));
        }
        return width;
    }
}

