/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.compat.emi;

import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.xylonity.tooltipoverhaul.compat.emi.EmiDeferredHover;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;

public final class EmiHoverHolder {
    private static final String RECIPESCREEN_CLASS_LOCATION = "dev.emi.emi.screen.RecipeScreen";

    private static boolean isTagCategory() {
        try {
            String id;
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91080_ == null) {
                return false;
            }
            Class<?> recipeScreen = Class.forName(RECIPESCREEN_CLASS_LOCATION, false, EmiHoverHolder.class.getClassLoader());
            if (!recipeScreen.isInstance(minecraft.f_91080_)) {
                return false;
            }
            Method method = recipeScreen.getMethod("getFocusedCategory", new Class[0]);
            Object category = method.invoke((Object)minecraft.f_91080_, new Object[0]);
            if (category == null) {
                return false;
            }
            Method getId = category.getClass().getMethod("getId", new Class[0]);
            Object idValue = getId.invoke(category, new Object[0]);
            String string = id = idValue == null ? null : idValue.toString();
            if (id == null) {
                return false;
            }
            String ss = id.toLowerCase(Locale.ROOT);
            return ss.contains("tag");
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static boolean isTagIngredient(EmiIngredient ei) {
        try {
            String isIng = ei.getClass().getName().toLowerCase(Locale.ROOT);
            return isIng.contains("tag");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static ItemStack getItemStack() {
        if (EmiHoverHolder.isTagCategory()) {
            return ItemStack.f_41583_;
        }
        ItemStack fromCache = EmiDeferredHover.pop();
        if (!fromCache.m_41619_()) {
            return fromCache;
        }
        ItemStack itemStack = EmiHoverHolder.fromRecipeScreen();
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        EmiStackInteraction internal = EmiApi.getHoveredStack((boolean)true);
        itemStack = EmiHoverHolder.getStack(internal);
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getItemStack(int mouseX, int mouseY) {
        if (EmiHoverHolder.isTagCategory()) {
            return ItemStack.f_41583_;
        }
        ItemStack fromCache = EmiDeferredHover.pop();
        if (!fromCache.m_41619_()) {
            return fromCache;
        }
        ItemStack itemStack = EmiHoverHolder.fromRecipeScreen();
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        EmiStackInteraction internal = EmiApi.getHoveredStack((int)mouseX, (int)mouseY, (boolean)true);
        itemStack = EmiHoverHolder.getStack(internal);
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        internal = EmiApi.getHoveredStack((int)mouseX, (int)mouseY, (boolean)false);
        itemStack = EmiHoverHolder.getStack(internal);
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        internal = EmiApi.getHoveredStack((boolean)true);
        itemStack = EmiHoverHolder.getStack(internal);
        if (!itemStack.m_41619_()) {
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack fromRecipeScreen() {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91080_ == null) {
                return ItemStack.f_41583_;
            }
            Class<?> resource = Class.forName(RECIPESCREEN_CLASS_LOCATION, false, EmiHoverHolder.class.getClassLoader());
            if (!resource.isInstance(minecraft.f_91080_)) {
                return ItemStack.f_41583_;
            }
            Method method = resource.getMethod("getHoveredStack", new Class[0]);
            Object ingred = method.invoke((Object)minecraft.f_91080_, new Object[0]);
            if (!(ingred instanceof EmiIngredient)) {
                return ItemStack.f_41583_;
            }
            EmiIngredient s = (EmiIngredient)ingred;
            if (EmiHoverHolder.isTagIngredient(s)) {
                return ItemStack.f_41583_;
            }
            return EmiHoverHolder.getStack(s);
        }
        catch (Exception exception) {
            return ItemStack.f_41583_;
        }
    }

    private static ItemStack getStack(EmiStackInteraction hovered) {
        if (hovered == null || hovered.isEmpty()) {
            return ItemStack.f_41583_;
        }
        EmiIngredient ingred = hovered.getStack();
        if (ingred == null) {
            return ItemStack.f_41583_;
        }
        if (EmiHoverHolder.isTagIngredient(ingred)) {
            return ItemStack.f_41583_;
        }
        return EmiHoverHolder.getStack(ingred);
    }

    private static ItemStack getStack(EmiIngredient ingred) {
        if (ingred == null) {
            return ItemStack.f_41583_;
        }
        List list = ingred.getEmiStacks();
        if (list == null || list.isEmpty()) {
            return ItemStack.f_41583_;
        }
        for (EmiStack es : list) {
            ItemStack st;
            if (es == null || (st = es.getItemStack()) == null || st.m_41619_()) continue;
            return st;
        }
        return ItemStack.f_41583_;
    }
}

