/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.renderer;

import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipRotatingItem;
import dev.xylonity.tooltipoverhaul.compat.modernfix.ModernFixCompat;
import dev.xylonity.tooltipoverhaul.config.TooltipsConfig;
import dev.xylonity.tooltipoverhaul.util.Util;
import java.awt.Point;
import net.minecraft.world.phys.Vec2;

public class DefaultRotatingItem
implements ITooltipRotatingItem {
    private static float SCALE = TooltipsConfig.SECOND_PANEL_RENDERER_SIZE;

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.renderDefault(depth, ctx, pos, size);
    }

    private void renderDefault(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        if (ctx.data().isPresent()) {
            SCALE = ctx.data().get().getSecondPanelRendererSize();
        }
        float speed = 8000.0f / TooltipsConfig.SECOND_PANEL_RENDERER_SPEED;
        if (ctx.data().isPresent()) {
            speed = 8000.0f / ctx.data().get().getSecondPanelRendererSpeed();
        }
        float finalSpeed = speed;
        ctx.push(() -> {
            ctx.translate(0.0f, 0.0f, depth.getZ());
            ctx.translate(pos.f_82470_, pos.f_82471_, 0.0f);
            ctx.multiply(Axis.f_252436_, -Util.calcRotY(finalSpeed));
            ctx.multiply(Axis.f_252403_, -45.0f);
            ctx.scale(SCALE, SCALE, SCALE);
            ctx.translate(-8.0f, -8.0f, -150.0f);
            if (ModernFixCompat.SHOULD_RETURN_ORIGINAL_RENDER) {
                ModernFixCompat.push();
                try {
                    ctx.graphics().m_280480_(ctx.stack(), 0, 0);
                }
                finally {
                    ModernFixCompat.pop();
                }
            } else {
                ctx.graphics().m_280480_(ctx.stack(), 0, 0);
            }
        });
    }
}

