/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.effect;

import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipEffect;
import java.awt.Point;
import net.minecraft.world.phys.Vec2;

public class MetalShiningEffect
implements ITooltipEffect {
    @Override
    public void render(LayerDepth depth, TooltipContext context, Vec2 pos, Point size) {
        int guiX = (int)pos.f_82470_;
        int guiY = (int)pos.f_82471_;
        int guiW = size.x;
        int guiH = size.y;
        context.push(() -> {
            context.graphics().m_280588_(guiX - 3, guiY - 3, guiX + guiW + 3, guiY + guiH + 3);
            float phase = (float)(System.currentTimeMillis() % 3500L) / 3500.0f;
            float frac = 0.2857143f;
            if (phase < frac) {
                float time = phase / frac;
                float startX = (float)(guiX + guiW) + 40.0f;
                float curX = startX + ((float)guiX - 100.0f - startX) * time;
                int baseDims = 3;
                int maxDims = 20;
                float theta = 1.0f - Math.abs(time - 0.25f) * 2.0f;
                int width = baseDims + Math.round((float)maxDims * theta);
                int height = 1000;
                int y = guiY + (guiH - height) / 2;
                float pivot = (float)y + (float)height / 2.0f;
                context.push(() -> {
                    context.translate(curX + (float)width / 2.0f, pivot, depth.getZ());
                    context.multiply(Axis.f_252403_, -30.0f);
                    context.multiply(Axis.f_252403_, 90.0f);
                    int newX = -height / 2;
                    int newY = -width / 2;
                    int fadeDims = width / 3;
                    int centerDims = width / 3;
                    context.graphics().m_280024_(newX, newY, newX + height, newY + fadeDims, 0xFFFFFF, -1);
                    context.graphics().m_280509_(newX, newY + fadeDims, newX + height, newY + fadeDims + centerDims, -1);
                    context.graphics().m_280024_(newX, newY + fadeDims + centerDims, newX + height, newY + width, -1, 0xFFFFFF);
                });
            }
            context.graphics().m_280618_();
        });
    }
}

