/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TooltipContext {
    private final GuiGraphics graphics;
    private final int mouseX;
    private final int mouseY;
    private final int screenW;
    private final int screenH;
    private final List<?> components;
    private ItemStack stack;
    private float elapsedSeconds = 0.0f;
    @Nullable
    private TooltipContext otherTooltipContext;
    private boolean isMainTooltip;
    private boolean halfWrapped = false;
    @Nullable
    private final CustomFrameData data;

    private TooltipContext(GuiGraphics graphics, int mouseX, int mouseY, int screenW, int screenH, List<ClientTooltipComponent> components, ItemStack stack, @Nullable TooltipContext otherTooltipContext, boolean isMainTooltip) {
        this.graphics = graphics;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.screenW = screenW;
        this.screenH = screenH;
        this.components = components;
        this.stack = stack;
        this.data = stack.m_41619_() ? null : (CustomFrameData)CustomFrameManager.of(stack).orElse(null);
        this.otherTooltipContext = otherTooltipContext;
        this.isMainTooltip = isMainTooltip;
    }

    public static TooltipContext of(GuiGraphics graphics, int mouseX, int mouseY, int screenW, int screenH, List<ClientTooltipComponent> components, ItemStack stack, @Nullable TooltipContext otherTooltipContext, boolean isMainTooltip) {
        return new TooltipContext(graphics, mouseX, mouseY, screenW, screenH, components, stack, otherTooltipContext, isMainTooltip);
    }

    public void setOtherTooltipContext(@Nullable TooltipContext otherTooltipContext) {
        this.otherTooltipContext = otherTooltipContext;
    }

    public boolean isMainTooltip() {
        return this.isMainTooltip;
    }

    @Nullable
    public TooltipContext getOtherTooltipContext() {
        return this.otherTooltipContext;
    }

    public Optional<CustomFrameData> data() {
        return Optional.ofNullable(this.data);
    }

    public List<?> getComponents() {
        return this.components;
    }

    public int mouseX() {
        return this.mouseX;
    }

    public int mouseY() {
        return this.mouseY;
    }

    public int width() {
        return this.screenW;
    }

    public int height() {
        return this.screenH;
    }

    public ItemStack stack() {
        return this.stack;
    }

    public float time() {
        return this.elapsedSeconds;
    }

    public GuiGraphics graphics() {
        return this.graphics;
    }

    public PoseStack pose() {
        return this.graphics.m_280168_();
    }

    public MultiBufferSource buffer() {
        return this.graphics.m_280091_();
    }

    public void push(Runnable r) {
        this.pose().m_85836_();
        try {
            r.run();
        }
        finally {
            this.pose().m_85849_();
        }
    }

    public void translate(float x, float y, float z) {
        this.pose().m_252880_(x, y, z);
    }

    public void scale(float x, float y, float z) {
        this.pose().m_85841_(x, y, z);
    }

    public void multiply(Axis axis, float degrees) {
        this.pose().m_252781_(axis.m_252977_(degrees));
    }

    public void flush() {
        this.graphics.m_280262_();
    }

    public void setHalfWrapped(boolean halfWrapped) {
        this.halfWrapped = halfWrapped;
    }

    public boolean isHalfWrapped() {
        return this.halfWrapped;
    }
}

