/*
 * Decompiled with CFR 0.152.
 */
package net.tokyosu.raritymod.utils;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tokyosu.raritymod.plugin.event.RarityStartupRegister;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class RarityUtils {
    public static boolean processItemRarity(CallbackInfoReturnable<Rarity> ci, Item item, ResourceLocation resource) {
        String resourceId = resource.toString();
        if (!RarityStartupRegister.isItemSame(resourceId)) {
            return false;
        }
        String rarityId = RarityStartupRegister.getItemRarity(resourceId);
        if (rarityId == null) {
            return false;
        }
        Rarity rarity = RarityStartupRegister.getRarity(rarityId);
        if (rarity == null && (rarity = RarityUtils.getMinecraftRarityByName(rarityId)) == null) {
            return false;
        }
        ci.setReturnValue((Object)rarity);
        return true;
    }

    public static boolean processModRarity(CallbackInfoReturnable<Rarity> ci, ResourceLocation resource) {
        String itemModId = RarityUtils.getModNameByResource(resource);
        if (!RarityStartupRegister.isModSame(itemModId)) {
            return false;
        }
        String rarityId = RarityStartupRegister.getModRarity(itemModId);
        if (rarityId == null) {
            return false;
        }
        Rarity rarity = RarityStartupRegister.getRarity(rarityId);
        if (rarity == null && (rarity = RarityUtils.getMinecraftRarityByName(rarityId)) == null) {
            return false;
        }
        ci.setReturnValue((Object)rarity);
        return true;
    }

    public static boolean processDefaultRarity(CallbackInfoReturnable<Rarity> ci) {
        String defaultRarity = RarityStartupRegister.getDefaultRarityId();
        if (defaultRarity == null) {
            return false;
        }
        Rarity rarity = RarityStartupRegister.getRarity(defaultRarity);
        if (rarity == null && (rarity = RarityUtils.getMinecraftRarityByName(defaultRarity)) == null) {
            return false;
        }
        ci.setReturnValue((Object)rarity);
        return true;
    }

    @Nullable
    public static ResourceLocation getResourceByItem(Item item) {
        IForgeRegistry items = ForgeRegistries.ITEMS;
        if (items.containsValue((Object)item)) {
            return items.getKey((Object)item);
        }
        return null;
    }

    @Nullable
    public static Rarity getMinecraftRarityByName(String name) {
        if (name.equalsIgnoreCase("minecraft.common")) {
            return Rarity.COMMON;
        }
        if (name.equalsIgnoreCase("minecraft.uncommon")) {
            return Rarity.UNCOMMON;
        }
        if (name.equalsIgnoreCase("minecraft.rare")) {
            return Rarity.RARE;
        }
        if (name.equalsIgnoreCase("minecraft.epic")) {
            return Rarity.EPIC;
        }
        return null;
    }

    public static String getModNameByResource(ResourceLocation location) {
        return location.m_135827_();
    }

    public static String getItemNameByResource(ResourceLocation location) {
        return location.m_135815_();
    }
}

