/*
 * Decompiled with CFR 0.152.
 */
package net.tokyosu.raritymod.mixin;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.tokyosu.raritymod.utils.RarityUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemRarityMixin {
    @Shadow
    public abstract Item m_41720_();

    @Inject(method={"getRarity"}, at={@At(value="RETURN")}, cancellable=true)
    private void changeRarity(CallbackInfoReturnable<Rarity> ci) {
        Item item = this.m_41720_();
        if (item != null) {
            ResourceLocation resourceLoc = RarityUtils.getResourceByItem(item);
            if (resourceLoc != null) {
                if (RarityUtils.processItemRarity(ci, item, resourceLoc)) {
                    return;
                }
                if (RarityUtils.processModRarity(ci, resourceLoc)) {
                    return;
                }
            }
            if (RarityUtils.processDefaultRarity(ci)) {
                return;
            }
        }
        ci.setReturnValue((Object)((Rarity)ci.getReturnValue()));
    }
}

