/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jeirei;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.PatternEncodingTermMenu;
import appeng.menu.slot.FakeSlot;
import appeng.parts.encoding.EncodingMode;
import appeng.util.CraftingRecipeUtil;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public final class EncodingHelper {
    static final Comparator<GridInventoryEntry> ENTRY_COMPARATOR = Comparator.comparing(GridInventoryEntry::isCraftable).thenComparing(EncodingHelper::isUndamaged).thenComparing(GridInventoryEntry::getStoredAmount);

    private EncodingHelper() {
    }

    private static Boolean isUndamaged(GridInventoryEntry entry) {
        AEItemKey itemKey;
        AEKey aEKey = entry.getWhat();
        return !(aEKey instanceof AEItemKey) || !(itemKey = (AEItemKey)aEKey).isDamaged();
    }

    public static void encodeProcessingRecipe(PatternEncodingTermMenu menu, List<List<GenericStack>> genericIngredients, List<GenericStack> genericResults) {
        menu.setMode(EncodingMode.PROCESSING);
        Map<AEKey, Integer> ingredientPriorities = EncodingHelper.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        EncodingHelper.encodeBestMatchingStacksIntoSlots(genericIngredients, ingredientPriorities, menu.getProcessingInputSlots());
        EncodingHelper.encodeBestMatchingStacksIntoSlots(genericResults.stream().map(List::of).toList(), ingredientPriorities, menu.getProcessingOutputSlots());
    }

    private static void encodeBestMatchingStacksIntoSlots(List<List<GenericStack>> possibleInputsBySlot, Map<AEKey, Integer> ingredientPriorities, FakeSlot[] slots) {
        ArrayList<GenericStack> encodedInputs = new ArrayList<GenericStack>();
        for (List<GenericStack> genericIngredient : possibleInputsBySlot) {
            if (genericIngredient.isEmpty()) continue;
            EncodingHelper.addOrMerge(encodedInputs, EncodingHelper.findBestIngredient(ingredientPriorities, genericIngredient));
        }
        for (int i = 0; i < slots.length; ++i) {
            FakeSlot slot = slots[i];
            ItemStack stack = i < encodedInputs.size() ? GenericStack.wrapInItemStack(encodedInputs.get(i)) : ItemStack.f_41583_;
            slot.setFilterTo(stack);
        }
    }

    public static boolean isSupportedCraftingRecipe(@Nullable Recipe<?> recipe) {
        if (recipe == null) {
            return false;
        }
        RecipeType recipeType = recipe.m_6671_();
        return recipeType == RecipeType.f_44107_ || recipeType == RecipeType.f_44112_ || recipeType == RecipeType.f_44113_;
    }

    public static void encodeCraftingRecipe(PatternEncodingTermMenu menu, @Nullable Recipe<?> recipe, List<List<GenericStack>> genericIngredients, Predicate<ItemStack> visiblePredicate) {
        if (recipe != null && recipe.m_6671_().equals(RecipeType.f_44112_)) {
            menu.setMode(EncodingMode.STONECUTTING);
            menu.setStonecuttingRecipeId(recipe.m_6423_());
        } else if (recipe != null && recipe.m_6671_().equals(RecipeType.f_44113_)) {
            menu.setMode(EncodingMode.SMITHING_TABLE);
        } else {
            menu.setMode(EncodingMode.CRAFTING);
        }
        Map<AEKey, Integer> prioritizedNetworkInv = EncodingHelper.getIngredientPriorities(menu, ENTRY_COMPARATOR);
        NonNullList encodedInputs = NonNullList.m_122780_((int)menu.getCraftingGridSlots().length, (Object)ItemStack.f_41583_);
        if (recipe != null) {
            NonNullList<Ingredient> ingredients3x3 = CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
            for (int slot = 0; slot < ingredients3x3.size(); ++slot) {
                Ingredient ingredient = (Ingredient)ingredients3x3.get(slot);
                if (ingredient.m_43947_()) continue;
                Optional<ItemStack> bestNetworkIngredient = prioritizedNetworkInv.entrySet().stream().filter(ni -> {
                    AEItemKey itemKey;
                    Object patt5605$temp = ni.getKey();
                    return patt5605$temp instanceof AEItemKey && (itemKey = (AEItemKey)patt5605$temp).matches(ingredient);
                }).max(Comparator.comparingInt(Map.Entry::getValue)).map(entry -> {
                    ItemStack itemStack;
                    Object patt5794$temp = entry.getKey();
                    if (patt5794$temp instanceof AEItemKey) {
                        AEItemKey itemKey = (AEItemKey)patt5794$temp;
                        itemStack = itemKey.toStack();
                    } else {
                        itemStack = null;
                    }
                    return itemStack;
                });
                ItemStack bestIngredient = bestNetworkIngredient.orElseGet(() -> {
                    for (ItemStack stack : ingredient.m_43908_()) {
                        if (!visiblePredicate.test(stack)) continue;
                        return stack;
                    }
                    return ingredient.m_43908_()[0];
                });
                encodedInputs.set(slot, (Object)bestIngredient);
            }
        } else {
            for (int slot = 0; slot < genericIngredients.size(); ++slot) {
                List<GenericStack> genericIngredient = genericIngredients.get(slot);
                if (genericIngredient.isEmpty()) continue;
                AEKey bestIngredient = EncodingHelper.findBestIngredient(prioritizedNetworkInv, genericIngredient).what();
                if (bestIngredient instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)bestIngredient;
                    encodedInputs.set(slot, (Object)itemKey.toStack());
                    continue;
                }
                encodedInputs.set(slot, (Object)GenericStack.wrapInItemStack(bestIngredient, 1L));
            }
        }
        for (int i = 0; i < encodedInputs.size(); ++i) {
            ItemStack encodedInput = (ItemStack)encodedInputs.get(i);
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, menu.getCraftingGridSlots()[i].f_40219_, encodedInput));
        }
        for (FakeSlot outputSlot : menu.getProcessingOutputSlots()) {
            NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, outputSlot.f_40219_, ItemStack.f_41583_));
        }
    }

    private static GenericStack findBestIngredient(Map<AEKey, Integer> ingredientPriorities, List<GenericStack> possibleIngredients) {
        return possibleIngredients.stream().map(gi -> Pair.of((Object)gi, (Object)ingredientPriorities.getOrDefault(gi.what(), Integer.MIN_VALUE))).max(Comparator.comparingInt(Pair::getRight)).map(Pair::getLeft).orElseThrow();
    }

    private static void addOrMerge(List<GenericStack> stacks, GenericStack newStack) {
        for (int i = 0; i < stacks.size(); ++i) {
            GenericStack existingStack = stacks.get(i);
            if (!Objects.equals(existingStack.what(), newStack.what())) continue;
            long newAmount = LongMath.saturatedAdd((long)existingStack.amount(), (long)newStack.amount());
            stacks.set(i, new GenericStack(newStack.what(), newAmount));
            long overflow = newStack.amount() - (newAmount - existingStack.amount());
            if (overflow > 0L) {
                stacks.add(new GenericStack(newStack.what(), overflow));
            }
            return;
        }
        stacks.add(newStack);
    }

    public static Map<AEKey, Integer> getIngredientPriorities(MEStorageMenu menu, Comparator<GridInventoryEntry> comparator) {
        List<AEKey> orderedEntries = menu.getClientRepo().getAllEntries().stream().sorted(comparator).map(GridInventoryEntry::getWhat).toList();
        HashMap<AEKey, Integer> result = new HashMap<AEKey, Integer>(orderedEntries.size());
        for (int i = 0; i < orderedEntries.size(); ++i) {
            result.put(orderedEntries.get(i), i);
        }
        for (ItemStack item : menu.getPlayerInventory().f_35974_) {
            AEItemKey key = AEItemKey.of(item);
            if (key == null) continue;
            result.putIfAbsent(key, -1);
        }
        return result;
    }
}

