/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.implementations.blockentities;

import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.stacks.AEItemKey;
import appeng.core.localization.GuiText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public record PatternContainerGroup(@Nullable AEItemKey icon, Component name, List<Component> tooltip) {
    private static final PatternContainerGroup NOTHING = new PatternContainerGroup(AEItemKey.of((ItemLike)Items.f_41852_), (Component)GuiText.Nothing.text(), List.of());

    public static PatternContainerGroup nothing() {
        return NOTHING;
    }

    public void writeToPacket(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.icon != null);
        if (this.icon != null) {
            this.icon.writeToPacket(buffer);
        }
        buffer.m_130083_(this.name);
        buffer.m_130130_(this.tooltip.size());
        for (Component component : this.tooltip) {
            buffer.m_130083_(component);
        }
    }

    public static PatternContainerGroup readFromPacket(FriendlyByteBuf buffer) {
        AEItemKey icon = buffer.readBoolean() ? AEItemKey.fromPacket(buffer) : null;
        Component name = buffer.m_130238_();
        int lineCount = buffer.m_130242_();
        ArrayList<Component> lines = new ArrayList<Component>(lineCount);
        for (int i = 0; i < lineCount; ++i) {
            lines.add(buffer.m_130238_());
        }
        return new PatternContainerGroup(icon, name, lines);
    }

    @Nullable
    public static PatternContainerGroup fromMachine(Level level, BlockPos pos, Direction side) {
        Component name;
        AEItemKey icon;
        BlockEntity target = level.m_7702_(pos);
        ICraftingMachine craftingMachine = ICraftingMachine.of(level, pos, side, target);
        if (craftingMachine != null) {
            return craftingMachine.getCraftingMachineInfo();
        }
        if (target == null) {
            return null;
        }
        ItemTransfer adaptor = InternalInventory.wrapExternal(target, side);
        if (adaptor == null || !adaptor.mayAllowInsertion()) {
            return null;
        }
        List<Component> tooltip = List.of();
        if (target instanceof IPartHost) {
            IPartHost partHost = (IPartHost)target;
            IPart part = partHost.getPart(side);
            if (part == null) {
                return null;
            }
            icon = AEItemKey.of(part.getPartItem());
            if (part instanceof Nameable) {
                Nameable nameable = (Nameable)part;
                name = nameable.m_5446_();
            } else {
                name = icon.getDisplayName();
            }
        } else {
            Nameable nameable;
            Block targetBlock = target.m_58900_().m_60734_();
            ItemStack targetItem = new ItemStack((ItemLike)targetBlock);
            icon = AEItemKey.of(targetItem);
            if (target instanceof Nameable && (nameable = (Nameable)target).m_8077_()) {
                name = nameable.m_7770_();
            } else {
                if (targetItem.m_41619_()) {
                    return null;
                }
                name = targetItem.m_41786_();
            }
        }
        return new PatternContainerGroup(icon, name, tooltip);
    }
}

