/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class FarmFieldRegistrationMessage
extends AbstractColonyServerMessage {
    private BlockPos position;

    public FarmFieldRegistrationMessage() {
    }

    public FarmFieldRegistrationMessage(IColony colony, BlockPos position) {
        super(colony);
        this.position = position;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony) {
        if (!isLogicalServer || ctxIn.getSender() == null) {
            return;
        }
        Optional field = colony.getBuildingManager().getBuildingExtensions(f -> f.getBuildingExtensionType().equals(BuildingExtensionRegistries.farmField.get()) && f.getPosition().equals((Object)this.position)).stream().findFirst();
        if (field.isEmpty()) {
            colony.getBuildingManager().addBuildingExtension(FarmField.create(this.position));
        }
    }

    @Override
    public void toBytesOverride(FriendlyByteBuf buf) {
        buf.m_130064_(this.position);
    }

    @Override
    public void fromBytesOverride(FriendlyByteBuf buf) {
        this.position = buf.m_130135_();
    }
}

