/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenFoodHandler;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.RestaurantMenuModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.colony.jobs.JobCook;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.other.SittingEntity;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.network.messages.client.ItemParticleEffectMessage;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class EntityAIEatTask
implements IStateAI {
    private static final Predicate<BuildingCook> STAFFED_RESTAURANTS = buildingCook -> buildingCook.getModule(BuildingModules.COOK_WORK).hasAssignedCitizen();
    private static final int MINUTES_WAITING_TIME = 2;
    private static final int REQUIRED_TIME_TO_EAT = 5;
    private static final int GET_YOURSELF_SATURATION = 30;
    public static final double RESTAURANT_LIMIT = 2.5;
    private static final int MINUTES_BETWEEN_FOOD_CHECKS = 5;
    private final EntityCitizen citizen;
    private int waitingTicks = 0;
    private int foodSlot = -1;
    private BlockPos eatPos = null;
    private BlockPos restaurantPos;
    private IBuilding restaurant;
    private int timeOutWalking = 0;
    private Set<Item> eatenFood = new LinkedHashSet<Item>();

    public EntityAIEatTask(EntityCitizen citizen) {
        this.citizen = citizen;
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(CitizenAIState.EATING, () -> true, () -> {
            this.reset();
            return EatingState.CHECK_FOR_FOOD;
        }, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(EatingState.DONE, () -> true, () -> CitizenAIState.IDLE, 1));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(EatingState.CHECK_FOR_FOOD, () -> true, this::getFood, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(EatingState.GO_TO_HUT, () -> true, this::goToHut, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(EatingState.EAT, () -> true, this::eat, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(EatingState.SEARCH_RESTAURANT, () -> true, this::searchRestaurant, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(EatingState.GO_TO_RESTAURANT, () -> true, this::goToRestaurant, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(EatingState.WAIT_FOR_FOOD, () -> true, this::waitForFood, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(EatingState.GO_TO_EAT_POS, () -> true, this::goToEatingPlace, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(EatingState.GET_FOOD_YOURSELF, () -> true, this::getFoodYourself, 20));
    }

    private EatingState getFood() {
        if (this.hasFood()) {
            return EatingState.EAT;
        }
        return EatingState.GO_TO_HUT;
    }

    private IState eat() {
        if (!this.hasFood()) {
            return EatingState.CHECK_FOR_FOOD;
        }
        ICitizenData citizenData = this.citizen.getCitizenData();
        ItemStack foodStack = citizenData.getInventory().getStackInSlot(this.foodSlot);
        if (!FoodUtils.canEat(foodStack, citizenData.getHomeBuilding(), citizenData.getWorkBuilding())) {
            return EatingState.CHECK_FOR_FOOD;
        }
        this.citizen.m_21008_(InteractionHand.MAIN_HAND, foodStack);
        this.citizen.m_6674_(InteractionHand.MAIN_HAND);
        this.citizen.m_5496_(SoundEvents.f_11912_, 1.0f, (float)SoundUtils.getRandomPitch(this.citizen.m_217043_()));
        Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(this.citizen.m_21205_(), this.citizen.m_20185_(), this.citizen.m_20186_(), this.citizen.m_20189_(), this.citizen.m_146909_(), this.citizen.m_146908_(), this.citizen.m_20192_()), (Entity)this.citizen);
        ++this.waitingTicks;
        if (this.waitingTicks < 5) {
            return EatingState.EAT;
        }
        ICitizenFoodHandler foodHandler = citizenData.getCitizenFoodHandler();
        if (this.eatenFood.isEmpty() && this.restaurant != null) {
            foodHandler.addLastEaten(foodStack.m_41720_());
        }
        this.eatenFood.add(foodStack.m_41720_());
        ItemStackUtils.consumeFood(foodStack, this.citizen, null);
        this.citizen.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        if (citizenData.getSaturation() < 20.0 && !citizenData.getInventory().getStackInSlot(this.foodSlot).m_41619_()) {
            this.waitingTicks = 0;
            return EatingState.EAT;
        }
        for (Item foodItem : this.eatenFood) {
            if (foodHandler.getLastEaten() == foodItem) continue;
            foodHandler.addLastEaten(foodItem);
        }
        this.eatenFood.clear();
        citizenData.setJustAte(true);
        return CitizenAIState.IDLE;
    }

    private EatingState getFoodYourself() {
        if (this.restaurantPos == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        IColony colony = this.citizen.getCitizenColonyHandler().getColonyOrRegister();
        IBuilding cookBuilding = colony.getBuildingManager().getBuilding(this.restaurantPos);
        if (cookBuilding instanceof BuildingCook) {
            JobCook jobCook;
            if (!EntityNavigationUtils.walkToBuilding(this.citizen, cookBuilding)) {
                return EatingState.GET_FOOD_YOURSELF;
            }
            ItemStorage storageToGet = FoodUtils.checkForFoodInBuilding(this.citizen.getCitizenData(), ((RestaurantMenuModule)cookBuilding.getModule(BuildingModules.RESTAURANT_MENU)).getMenu(), cookBuilding);
            if (storageToGet != null) {
                int qty = (int)Math.max(1.0, (20.0 - this.citizen.getCitizenData().getSaturation()) / FoodUtils.getFoodValue(storageToGet.getItemStack(), this.citizen));
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(cookBuilding, storageToGet, qty, (IItemHandler)this.citizen.getInventoryCitizen());
                return EatingState.EAT;
            }
            IJob<?> iJob = this.citizen.getCitizenData().getJob();
            if (iJob instanceof JobCook && (jobCook = (JobCook)iJob).getBuildingPos().equals((Object)this.restaurantPos) && MathUtils.RANDOM.nextInt(20) <= 0) {
                this.reset();
                return EatingState.DONE;
            }
        }
        return EatingState.WAIT_FOR_FOOD;
    }

    private EatingState goToEatingPlace() {
        if (this.eatPos == null || this.timeOutWalking++ > 400) {
            if (this.hasFood()) {
                this.timeOutWalking = 0;
                return EatingState.EAT;
            }
            ++this.waitingTicks;
            if (this.waitingTicks > 120 || this.citizen.getCitizenData().getJob() instanceof AbstractJobGuard && !WorldUtil.isDayTime(this.citizen.f_19853_)) {
                this.waitingTicks = 0;
                return EatingState.GET_FOOD_YOURSELF;
            }
        }
        if (this.eatPos != null && EntityNavigationUtils.walkToPos(this.citizen, this.eatPos, 2, true)) {
            SittingEntity.sitDown(this.eatPos, (Mob)this.citizen, 1200);
            this.timeOutWalking += 10;
            if (!this.hasFood()) {
                ++this.waitingTicks;
                if (this.waitingTicks > 120) {
                    this.waitingTicks = 0;
                    return EatingState.GET_FOOD_YOURSELF;
                }
            }
        }
        return EatingState.GO_TO_EAT_POS;
    }

    private BlockPos findPlaceToEat() {
        IBuilding restaurant;
        if (this.restaurantPos != null && (restaurant = this.citizen.getCitizenData().getColony().getBuildingManager().getBuilding(this.restaurantPos)) instanceof BuildingCook) {
            return ((BuildingCook)restaurant).getNextSittingPosition();
        }
        return null;
    }

    private EatingState waitForFood() {
        ICitizenData citizenData = this.citizen.getCitizenData();
        IColony colony = citizenData.getColony();
        this.restaurantPos = colony.getBuildingManager().getBestBuilding(this.citizen, BuildingCook.class);
        if (this.restaurantPos == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        this.restaurant = colony.getBuildingManager().getBuilding(this.restaurantPos);
        if (!this.restaurant.isInBuilding(this.citizen.m_20183_())) {
            return EatingState.GO_TO_RESTAURANT;
        }
        this.eatPos = this.findPlaceToEat();
        if (this.restaurant != null) {
            return EatingState.GO_TO_EAT_POS;
        }
        if (this.hasFood()) {
            return EatingState.EAT;
        }
        return EatingState.WAIT_FOR_FOOD;
    }

    private EatingState goToHut() {
        IBuilding buildingWorker = this.citizen.getCitizenData().getWorkBuilding();
        if (buildingWorker == null) {
            return EatingState.SEARCH_RESTAURANT;
        }
        if (EntityNavigationUtils.walkToBuilding(this.citizen, buildingWorker)) {
            ItemStorage storageToGet;
            int slot = FoodUtils.getBestFoodForCitizen(this.citizen.getInventoryCitizen(), this.citizen.getCitizenData(), null);
            if (slot != -1 && (storageToGet = FoodUtils.checkForFoodInBuilding(this.citizen.getCitizenData(), null, buildingWorker)) != null && InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(buildingWorker, storageToGet, (IItemHandler)this.citizen.getInventoryCitizen())) {
                this.restaurant = null;
                return EatingState.EAT;
            }
            return EatingState.SEARCH_RESTAURANT;
        }
        this.restaurant = null;
        return EatingState.GO_TO_HUT;
    }

    private EatingState goToRestaurant() {
        IBuilding building;
        if (this.restaurantPos != null && (building = this.citizen.getCitizenColonyHandler().getColonyOrRegister().getBuildingManager().getBuilding(this.restaurantPos)) != null) {
            if (building.isInBuilding(this.citizen.m_20183_())) {
                return EatingState.WAIT_FOR_FOOD;
            }
            if (!EntityNavigationUtils.walkToBuilding(this.citizen, building)) {
                return EatingState.GO_TO_RESTAURANT;
            }
        }
        return EatingState.SEARCH_RESTAURANT;
    }

    private EatingState searchRestaurant() {
        IJob<?> job;
        ICitizenData citizenData = this.citizen.getCitizenData();
        IColony colony = citizenData.getColony();
        BlockPos searchFrom = citizenData.getWorkBuilding() != null ? citizenData.getWorkBuilding().getPosition() : (citizenData.getHomeBuilding() != null ? citizenData.getHomeBuilding().getPosition() : this.citizen.m_20183_());
        this.restaurantPos = colony.getBuildingManager().getBestBuilding(searchFrom, BuildingCook.class, STAFFED_RESTAURANTS);
        if (this.restaurantPos == null) {
            this.restaurantPos = colony.getBuildingManager().getBestBuilding(searchFrom, BuildingCook.class);
        }
        if ((job = this.citizen.getCitizenJobHandler().getColonyJob()) != null && citizenData.isWorking()) {
            citizenData.setWorking(false);
        }
        if (this.restaurantPos == null) {
            if (this.citizen.getCitizenData().getSaturation() >= 10.0) {
                this.reset();
                citizenData.setJustAte(true);
                return EatingState.DONE;
            }
            citizenData.triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.norestaurant"), ChatPriority.BLOCKING));
            return EatingState.CHECK_FOR_FOOD;
        }
        return EatingState.GO_TO_RESTAURANT;
    }

    private boolean hasFood() {
        int slot = FoodUtils.getBestFoodForCitizen(this.citizen.getInventoryCitizen(), this.citizen.getCitizenData(), this.restaurant == null ? null : ((RestaurantMenuModule)this.restaurant.getModule(BuildingModules.RESTAURANT_MENU)).getMenu());
        if (slot != -1) {
            this.foodSlot = slot;
            return true;
        }
        ICitizenData citizenData = this.citizen.getCitizenData();
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.citizen.getInventoryCitizen(), stack -> FoodUtils.canEat(stack, citizenData.getHomeBuilding(), citizenData.getWorkBuilding()))) {
            if (citizenData.isChild()) {
                citizenData.triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.betterfood.children"), ChatPriority.BLOCKING));
            } else {
                citizenData.triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.betterfood"), ChatPriority.BLOCKING));
            }
        } else if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.citizen.getInventoryCitizen(), ItemStackUtils.ISCOOKABLE)) {
            citizenData.triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.ai.wrongfood"), ChatPriority.PENDING));
        }
        return false;
    }

    private void reset() {
        this.waitingTicks = 0;
        this.foodSlot = -1;
        this.citizen.m_21253_();
        this.citizen.m_5810_();
        this.citizen.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        this.restaurantPos = null;
        this.eatPos = null;
        this.eatenFood.clear();
        this.restaurant = null;
    }

    public static enum EatingState implements IState
    {
        CHECK_FOR_FOOD,
        GO_TO_HUT,
        SEARCH_RESTAURANT,
        GO_TO_RESTAURANT,
        WAIT_FOR_FOOD,
        GET_FOOD_YOURSELF,
        GO_TO_EAT_POS,
        EAT,
        DONE;

    }
}

