/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class CommandCitizenModify
implements IMCColonyOfficerCommand {
    private static final String VALUE_ARG = "value";

    @Override
    public int onExecute(@NotNull CommandContext<CommandSourceStack> context) {
        return 0;
    }

    @Override
    @NotNull
    public String getName() {
        return "modify";
    }

    @Override
    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral("saturation").then(IMCCommand.newLiteral("=").then(IMCCommand.newArgument(VALUE_ARG, DoubleArgumentType.doubleArg((double)0.0, (double)20.0)).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("0.0", String.valueOf(20)), (SuggestionsBuilder)builder)).executes(ctx -> this.adjust((CommandContext<CommandSourceStack>)ctx, citizen -> citizen.setSaturation(DoubleArgumentType.getDouble((CommandContext)ctx, (String)VALUE_ARG)), citizen -> String.valueOf(citizen.getSaturation())))))).then(IMCCommand.newLiteral("+").then(IMCCommand.newArgument(VALUE_ARG, DoubleArgumentType.doubleArg((double)0.0, (double)20.0)).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("1.0"), (SuggestionsBuilder)builder)).executes(ctx -> this.adjust((CommandContext<CommandSourceStack>)ctx, citizen -> citizen.increaseSaturation(DoubleArgumentType.getDouble((CommandContext)ctx, (String)VALUE_ARG)), citizen -> String.valueOf(citizen.getSaturation())))))).then(IMCCommand.newLiteral("-").then(IMCCommand.newArgument(VALUE_ARG, DoubleArgumentType.doubleArg((double)0.0, (double)20.0)).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("1.0"), (SuggestionsBuilder)builder)).executes(ctx -> this.adjust((CommandContext<CommandSourceStack>)ctx, citizen -> citizen.decreaseSaturation(DoubleArgumentType.getDouble((CommandContext)ctx, (String)VALUE_ARG)), citizen -> String.valueOf(citizen.getSaturation()))))))));
    }

    private int adjust(@NotNull CommandContext<CommandSourceStack> context, @NotNull Consumer<ICitizenData> action, @NotNull Function<ICitizenData, String> valueProvider) {
        return this.execute(context, citizen -> {
            action.accept((ICitizenData)citizen);
            String type = ((ParsedCommandNode)context.getNodes().get(5)).getNode().getName();
            String value = (String)valueProvider.apply((ICitizenData)citizen);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.citizenmodify.success", (Object[])new Object[]{type, citizen.getName(), value}), true);
            return 0;
        });
    }

    private int execute(@NotNull CommandContext<CommandSourceStack> context, @NotNull ToIntFunction<ICitizenData> action) {
        try {
            if (!this.checkPreCondition(context)) {
                return 0;
            }
            if (!((CommandSourceStack)context.getSource()).m_6761_(4) && !((Boolean)MineColonies.getConfig().getServer().canPlayerUseModifyCitizensCommand.get()).booleanValue()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.notenabledinconfig"), true);
                return 0;
            }
            if (!(((CommandSourceStack)context.getSource()).f_81288_ instanceof MinecraftServer || ((CommandSourceStack)context.getSource()).m_230897_() && ((CommandSourceStack)context.getSource()).m_230896_().m_7500_())) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.notcreative"), true);
                return 0;
            }
            IColony colony = ColonyIdArgument.getColony(context, "colonyID");
            ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
            if (citizenData == null) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"com.minecolonies.command.citizeninfo.notfound"), true);
                return 0;
            }
            return action.applyAsInt(citizenData);
        }
        catch (Throwable e) {
            Log.getLogger().warn("Error during running command:", e);
            return 0;
        }
    }
}

