/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public class BuildingBlacksmith
extends AbstractBuilding {
    private static final String BLACKSMITH = "blacksmith";

    public BuildingBlacksmith(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BLACKSMITH;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_BLACKSMITH).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            if (recipe.matchesInput(OptionalPredicate.failIf(input -> input.m_150930_(Items.f_42454_))).equals(Optional.of(false))) {
                return false;
            }
            if (recipe.matchesOutput(OptionalPredicate.passIf(output -> ((EquipmentTypeEntry)ModEquipmentTypes.axe.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.shovel.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.hoe.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.shears.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.sword.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.shield.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.helmet.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.chestplate.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.leggings.get()).checkIsEquipment((ItemStack)output) || ((EquipmentTypeEntry)ModEquipmentTypes.boots.get()).checkIsEquipment((ItemStack)output) || Compatibility.isTinkersWeapon(output))).equals(Optional.of(true))) {
                return true;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_BLACKSMITH).orElse(false);
        }
    }
}

