/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.views;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.WindowHutMinPlaceholder;
import com.minecolonies.core.client.gui.huts.WindowHutWorkerModulePlaceholder;
import com.minecolonies.core.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.network.messages.server.colony.building.HutRenameMessage;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingView
implements IBuildingView {
    private final IColonyView colony;
    @NotNull
    private final BlockPos location;
    @NotNull
    private BlockPos parent = BlockPos.f_121853_;
    private int buildingLevel = 0;
    private int buildingMaxLevel = 0;
    private int buildingDmPrio = 1;
    private int rotation;
    private boolean isBuildingMirrored;
    private int workOrderLevel = -1;
    private ImmutableCollection<IToken<?>> resolvers;
    private IToken<?> requesterId;
    private IToken<?> rsDataStoreToken;
    private String path;
    private String pack;
    private String customName = "";
    private int claimRadius = 0;
    private List<BlockPos> containerlist = new ArrayList<BlockPos>();
    private boolean isDeconstructed;
    private boolean isAssignmentAllowed;
    protected Int2ObjectLinkedOpenHashMap<IBuildingModuleView> moduleViews = new Int2ObjectLinkedOpenHashMap();
    private BuildingEntry buildingType;

    protected AbstractBuildingView(IColonyView c, @NotNull BlockPos l) {
        this.colony = c;
        this.location = new BlockPos((Vec3i)l);
    }

    @Override
    @NotNull
    public BlockPos getID() {
        return this.location;
    }

    @Override
    @NotNull
    public BlockPos getPosition() {
        return this.location;
    }

    @Override
    @NotNull
    public BlockPos getParent() {
        return this.parent;
    }

    @Override
    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public int getBuildingMaxLevel() {
        return this.buildingMaxLevel;
    }

    @Override
    public boolean isBuildingMaxLevel() {
        return this.buildingLevel >= this.buildingMaxLevel;
    }

    @Override
    public int getCurrentWorkOrderLevel() {
        return this.workOrderLevel;
    }

    @Override
    public String getStructurePath() {
        return this.path;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public String getStructurePack() {
        return this.pack;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    @Override
    public boolean hasWorkOrder() {
        return this.workOrderLevel != -1;
    }

    @Override
    public boolean isBuilding() {
        return this.workOrderLevel != 0 && this.workOrderLevel != -1 && this.workOrderLevel > this.buildingLevel;
    }

    @Override
    public boolean isRepairing() {
        return this.workOrderLevel != 0 && this.workOrderLevel != -1 && this.workOrderLevel == this.buildingLevel;
    }

    @Override
    public boolean isDeconstructing() {
        return this.workOrderLevel == 0;
    }

    @Override
    public int getClaimRadius() {
        return this.claimRadius;
    }

    @Override
    public List<BlockPos> getContainerList() {
        return new ArrayList<BlockPos>(this.containerlist);
    }

    @Override
    public void openGui(boolean shouldOpenInv) {
        if (shouldOpenInv) {
            Network.getNetwork().sendToServer(new OpenInventoryMessage(this));
        } else {
            @Nullable BOWindow window = this.getWindow();
            if (window != null) {
                window.open();
            }
        }
    }

    @Override
    @NotNull
    public BOWindow getWindow() {
        if (!this.getModuleViews(WorkerBuildingModuleView.class).isEmpty()) {
            return new WindowHutWorkerModulePlaceholder<AbstractBuildingView>(this);
        }
        return new WindowHutMinPlaceholder<AbstractBuildingView>(this);
    }

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        int i;
        this.buildingLevel = buf.readInt();
        this.buildingMaxLevel = buf.readInt();
        this.buildingDmPrio = buf.readInt();
        this.workOrderLevel = buf.readInt();
        this.pack = buf.m_130136_(Short.MAX_VALUE);
        this.path = buf.m_130136_(Short.MAX_VALUE);
        this.parent = buf.m_130135_();
        this.customName = buf.m_130136_(Short.MAX_VALUE);
        this.rotation = buf.readInt();
        this.isBuildingMirrored = buf.readBoolean();
        this.claimRadius = buf.readInt();
        ArrayList<IToken> list = new ArrayList<IToken>();
        int resolverSize = buf.readInt();
        for (int i2 = 0; i2 < resolverSize; ++i2) {
            CompoundTag compound = buf.m_130260_();
            if (compound == null) continue;
            list.add((IToken)StandardFactoryController.getInstance().deserialize(compound));
        }
        this.resolvers = ImmutableList.copyOf(list);
        CompoundTag compound = buf.m_130260_();
        if (compound != null) {
            this.requesterId = (IToken)StandardFactoryController.getInstance().deserialize(compound);
        }
        this.containerlist.clear();
        int racks = buf.readInt();
        for (i = 0; i < racks; ++i) {
            this.containerlist.add(buf.m_130135_());
        }
        this.loadRequestSystemFromNBT(buf.m_130260_());
        this.isDeconstructed = buf.readBoolean();
        this.isAssignmentAllowed = buf.readBoolean();
        int size = buf.readInt();
        for (i = 0; i < size; ++i) {
            int id = buf.readInt();
            IBuildingModuleView moduleView = (IBuildingModuleView)this.moduleViews.get(id);
            if (moduleView == null) {
                Log.getLogger().error("Problem during sync: Client side does not have matching module views to sent module data, missing:" + BuildingEntry.getProducer((int)id).key);
                return;
            }
            moduleView.deserialize(buf);
        }
    }

    private void loadRequestSystemFromNBT(CompoundTag compound) {
        this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.m_128469_("DataStoreToken"));
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    protected Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull ICitizenDataView citizenData, Class<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf((Type)requestType)).map(request -> request).iterator());
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequests(@NotNull ICitizenDataView data) {
        if (data == null || this.getColony() == null || this.getColony().getRequestManager() == null) {
            return ImmutableList.of();
        }
        if (!this.getOpenRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        Collection<IToken<?>> list = this.getOpenRequestsByCitizen().get(data.getId());
        if (list == null || list.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(list.stream().filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequestsOfBuilding() {
        return ImmutableList.copyOf(this.getOpenRequestsByCitizen().values().stream().flatMap(Collection::stream).filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public IColonyView getColony() {
        return this.colony;
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenDataView citizenData, Class<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf((Type)requestType)).map(request -> request).filter(filter).iterator());
    }

    @Override
    public IToken<?> getId() {
        return this.requesterId;
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        ((Collection)this.getOpenRequestsByCitizen().getOrDefault(citizenThatRequested, new ArrayList())).remove(request.getId());
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (this.getOpenRequestsOfBuilding().contains(request)) {
            Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
            ((Collection)this.getOpenRequestsByCitizen().getOrDefault(citizenThatRequested, new ArrayList())).remove(request.getId());
        }
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        try {
            MutableComponent component = Component.m_237113_((String)"");
            component.m_7220_((Component)Component.m_237115_((String)(this.getCustomName().isEmpty() ? this.getBuildingType().getTranslationKey() : this.getCustomName())));
            if (this.getColony() == null || !this.getCitizensByRequest().containsKey(request.getId())) {
                return component;
            }
            int citizenId = this.getCitizensByRequest().get(request.getId());
            if (citizenId == -1 && this.getAllAssignedCitizens().size() == 1) {
                citizenId = this.getAllAssignedCitizens().iterator().next();
            }
            if (citizenId == -1 || this.getColony().getCitizen(citizenId) == null) {
                return component;
            }
            component.m_7220_((Component)Component.m_237113_((String)": "));
            component.m_7220_((Component)Component.m_237113_((String)this.getColony().getCitizen(citizenId).getName()));
            return component;
        }
        catch (Exception ex) {
            Log.getLogger().warn((Object)ex);
            return Component.m_237113_((String)"");
        }
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return null;
    }

    @Override
    public int getBuildingDmPrio() {
        return this.buildingDmPrio;
    }

    @Override
    public ImmutableCollection<IToken<?>> getResolverIds() {
        return this.resolvers;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
        Network.getNetwork().sendToServer(new HutRenameMessage(this, name));
    }

    @Override
    public boolean isDeconstructed() {
        return this.isDeconstructed;
    }

    @Override
    public IBuildingModuleView getModuleView(int id) {
        return (IBuildingModuleView)this.moduleViews.get(id);
    }

    @Override
    public <M extends IBuildingModule, V extends IBuildingModuleView> V getModuleView(BuildingEntry.ModuleProducer<M, V> producer) {
        return (V)((IBuildingModuleView)this.moduleViews.get(producer.getRuntimeID()));
    }

    @Override
    public boolean hasModuleView(BuildingEntry.ModuleProducer producer) {
        return this.moduleViews.containsKey(producer.getRuntimeID());
    }

    @Override
    @NotNull
    public <T extends IBuildingModuleView> T getModuleViewByType(Class<T> clazz) {
        for (IBuildingModuleView view : this.moduleViews.values()) {
            if (!clazz.isInstance(view)) continue;
            return (T)view;
        }
        return null;
    }

    @Override
    public <T extends IBuildingModuleView> T getModuleViewMatching(Class<T> clazz, Predicate<? super T> modulePredicate) {
        for (IBuildingModuleView module : this.moduleViews.values()) {
            if (!clazz.isInstance(module) || !modulePredicate.test(clazz.cast(module))) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    @NotNull
    public <T extends IBuildingModuleView> List<T> getModuleViews(Class<T> clazz) {
        return this.moduleViews.values().stream().filter(clazz::isInstance).map(c -> c).collect(Collectors.toList());
    }

    @Override
    public void registerModule(IBuildingModuleView iModuleView) {
        iModuleView.setBuildingView(this);
        this.moduleViews.put(iModuleView.getProducer().getRuntimeID(), (Object)iModuleView);
    }

    @Override
    public List<IBuildingModuleView> getAllModuleViews() {
        return Collections.unmodifiableList(new ArrayList(this.moduleViews.values()));
    }

    @Override
    public final BuildingEntry getBuildingType() {
        return this.buildingType;
    }

    @Override
    public void setBuildingType(BuildingEntry buildingType) {
        this.buildingType = buildingType;
    }

    @Override
    public Set<Integer> getAllAssignedCitizens() {
        HashSet<Integer> assignees = new HashSet<Integer>();
        for (WorkerBuildingModuleView view : this.getModuleViews(WorkerBuildingModuleView.class)) {
            assignees.addAll(view.getAssignedCitizens());
        }
        return assignees;
    }

    @Override
    public boolean allowsAssignment() {
        return this.isAssignmentAllowed;
    }
}

