/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.modules.SettingsModuleWindow;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.network.messages.server.colony.building.TriggerSettingMessage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsModuleView
extends AbstractBuildingModuleView
implements ISettingsModuleView {
    final Map<ISettingKey<? extends ISetting>, ISetting> settings = new LinkedHashMap<ISettingKey<? extends ISetting>, ISetting>();

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        LinkedHashMap tempSettings = new LinkedHashMap();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buf.m_130281_();
            ISetting setting = (ISetting)StandardFactoryController.getInstance().deserialize(buf);
            if (setting == null) continue;
            SettingKey settingsKey = new SettingKey(setting.getClass(), key);
            tempSettings.put(settingsKey, setting);
            this.settings.putIfAbsent(settingsKey, setting);
        }
        for (Map.Entry<ISettingKey<? extends ISetting>, ISetting> entry : new ArrayList<Map.Entry<ISettingKey<? extends ISetting>, ISetting>>(this.settings.entrySet())) {
            ISetting syncSetting = (ISetting)tempSettings.get(entry.getKey());
            if (syncSetting == null) {
                this.settings.remove(entry.getKey());
                continue;
            }
            if (entry.getValue() == syncSetting) continue;
            entry.getValue().updateSetting(syncSetting);
            entry.getValue().copyValue(syncSetting);
        }
    }

    public List<ISettingKey<? extends ISetting>> getSettingsToShow() {
        ArrayList<ISettingKey<? extends ISetting>> filteredSettings = new ArrayList<ISettingKey<? extends ISetting>>();
        for (Map.Entry<ISettingKey<? extends ISetting>, ISetting> setting : this.settings.entrySet()) {
            if (!setting.getValue().isActive(this) && setting.getValue().shouldHideWhenInactive()) continue;
            filteredSettings.add(setting.getKey());
        }
        return filteredSettings;
    }

    @Override
    @Nullable
    public <T extends ISetting> T getSetting(ISettingKey<T> key) {
        return (T)((ISetting)this.settings.getOrDefault(key, null));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new SettingsModuleWindow(this);
    }

    @Override
    public ResourceLocation getIconResourceLocation() {
        return new ResourceLocation("minecolonies", "textures/gui/modules/settings.png");
    }

    @Override
    public Component getDesc() {
        return Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.settings");
    }

    @Override
    public void trigger(ISettingKey<?> key) {
        ISetting setting = this.settings.get(key);
        if (setting.isActive(this)) {
            setting.trigger();
            Network.getNetwork().sendToServer(new TriggerSettingMessage(this.buildingView, key, setting, this.getProducer().getRuntimeID()));
        }
    }
}

