/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.core.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BuildingResourcesModuleView
extends AbstractBuildingModuleView {
    private final HashMap<String, BuildingBuilderResource> resources = new HashMap();
    private int workOrderId;
    private double progress;
    private int finishedStages = 0;
    private int totalStages = 1;

    @Override
    public void deserialize(@NotNull FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.resources.clear();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = buf.m_130267_();
            int amountAvailable = buf.readInt();
            int amountNeeded = buf.readInt();
            BuildingBuilderResource resource = new BuildingBuilderResource(itemStack, amountNeeded, amountAvailable);
            int hashCode = itemStack.m_41782_() ? itemStack.m_41783_().hashCode() : 0;
            String key = itemStack.m_41778_() + "-" + hashCode;
            this.resources.put(key, resource);
        }
        this.workOrderId = buf.readInt();
        this.progress = buf.readDouble();
        this.totalStages = buf.readInt();
        this.finishedStages = buf.readInt();
    }

    public int getWorkOrderId() {
        return this.workOrderId;
    }

    public Map<String, BuildingBuilderResource> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    public int getProgress() {
        int localProgress = Math.max(100 - (int)(this.progress * 100.0), 0);
        if (this.finishedStages == 0 && this.totalStages == this.finishedStages) {
            return 0;
        }
        return localProgress;
    }

    public int getCurrentStage() {
        return this.finishedStages;
    }

    public int getTotalStages() {
        return this.totalStages;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new WindowBuilderResModule(this);
    }

    @Override
    public ResourceLocation getIconResourceLocation() {
        return new ResourceLocation("minecolonies", "textures/gui/modules/inventory.png");
    }

    @Override
    public Component getDesc() {
        return Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.resourcelist");
    }
}

