/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AnimalHerdingModule
extends AbstractBuildingModule {
    private final JobEntry jobEntry;
    private final Predicate<Animal> animalPredicate;
    private final ItemStorage breedingItem;

    public AnimalHerdingModule(@NotNull JobEntry jobEntry, @NotNull Predicate<Animal> animalPredicate, @NotNull ItemStorage breedingItem) {
        this.jobEntry = jobEntry;
        this.animalPredicate = animalPredicate;
        this.breedingItem = breedingItem;
    }

    @NotNull
    public IJob<?> getHerdingJob() {
        return this.jobEntry.produceJob(null);
    }

    public boolean isCompatible(@NotNull Animal animal) {
        return this.animalPredicate.test(animal);
    }

    @NotNull
    public List<ItemStorage> getBreedingItems() {
        return Collections.singletonList(this.breedingItem);
    }

    @NotNull
    public List<ResourceLocation> getLootTables(@NotNull Animal animal) {
        return Collections.singletonList(animal.m_5743_());
    }

    @NotNull
    public List<IGenericRecipe> getRecipesForDisplayPurposesOnly(@NotNull Animal animal) {
        return List.of(GenericRecipe.builder().withRecipeId(ForgeRegistries.ENTITY_TYPES.getKey((Object)animal.m_6095_())).withInputs(List.of(this.getBreedingItems().stream().map(ItemStorage::getItemStack).toList())).withLootTable(animal.m_5743_()).withRequiredTool((EquipmentTypeEntry)ModEquipmentTypes.axe.get()).withRequiredEntity(animal.m_6095_()).build());
    }
}

