/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.BuildingStatisticsModuleView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WindowStatsModule
extends AbstractModuleWindow<BuildingStatisticsModuleView> {
    private static final LinkedHashMap<String, Integer> INTERVAL = new LinkedHashMap();
    private static final String TAG_BUTTON_HIDEZERO = "hidezero";
    private static final String TEXTURE_ASSIGN_ON_NORMAL = "minecolonies:textures/gui/builderhut/builder_button_mini_check.png";
    private static final String TEXTURE_ASSIGN_ON_DISABLED = "minecolonies:textures/gui/builderhut/builder_button_mini_disabled_check.png";
    private static final String TEXTURE_ASSIGN_OFF_NORMAL = "minecolonies:textures/gui/builderhut/builder_button_mini.png";
    private static final String TEXTURE_ASSIGN_OFF_DISABLED = "minecolonies:textures/gui/builderhut/builder_button_mini_disabled.png";
    public String selectedInterval = "com.minecolonies.coremod.gui.interval.yesterday";
    private boolean hideZeroStats = false;

    public WindowStatsModule(BuildingStatisticsModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutstatsmodule.xml"));
        this.registerButton(TAG_BUTTON_HIDEZERO, this::hideZeroClicked);
    }

    public void onOpened() {
        super.onOpened();
        this.updateStats();
    }

    private void updateStats() {
        final IStatisticsManager statisticsManager = ((BuildingStatisticsModuleView)this.moduleView).getBuildingStatisticsManager();
        final @NotNull ArrayList<String> stats = new ArrayList<String>(statisticsManager.getStatTypes());
        ((ScrollingList)this.findPaneOfTypeByID("stats", ScrollingList.class)).setDataProvider(new ScrollingList.DataProvider(){
            private final List<String> filteredStats = new ArrayList<String>();
            {
                int interval = INTERVAL.get(WindowStatsModule.this.selectedInterval);
                if (WindowStatsModule.this.hideZeroStats) {
                    for (int i = 0; i < stats.size(); ++i) {
                        if (interval > 0) {
                            if (statisticsManager.getStatsInPeriod((String)stats.get(i), WindowStatsModule.this.buildingView.getColony().getDay() - interval, WindowStatsModule.this.buildingView.getColony().getDay()) <= 0) continue;
                            this.filteredStats.add((String)stats.get(i));
                            continue;
                        }
                        if (statisticsManager.getStatTotal((String)stats.get(i)) <= 0) continue;
                        this.filteredStats.add((String)stats.get(i));
                    }
                } else {
                    this.filteredStats.addAll(stats);
                }
            }

            public int getElementCount() {
                return this.filteredStats.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                int stat = statisticsManager.getStatTotal(this.filteredStats.get(index));
                int interval = INTERVAL.get(WindowStatsModule.this.selectedInterval);
                if (interval > 0) {
                    stat = statisticsManager.getStatsInPeriod(this.filteredStats.get(index), WindowStatsModule.this.buildingView.getColony().getDay() - interval, WindowStatsModule.this.buildingView.getColony().getDay());
                }
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("desc", Text.class);
                String id = this.filteredStats.get(index);
                if (id.contains(";")) {
                    String[] split = id.split(";");
                    if (id.contains("'")) {
                        String[] split2 = split[1].split("'");
                        resourceLabel.setText(Component.m_237110_((String)("com.minecolonies.coremod.gui.townhall.stats." + split[0]), (Object[])new Object[]{stat, Component.m_237115_((String)split2[1])}));
                    } else {
                        resourceLabel.setText(Component.m_237110_((String)("com.minecolonies.coremod.gui.townhall.stats." + split[0]), (Object[])new Object[]{stat, Component.m_237115_((String)split[1])}));
                    }
                } else {
                    resourceLabel.setText(Component.m_237110_((String)("com.minecolonies.coremod.gui.townhall.stats." + id), (Object[])new Object[]{stat}));
                }
                PaneBuilders.tooltipBuilder().hoverPane((Pane)resourceLabel).build().setText(resourceLabel.getText());
            }
        });
        DropDownList intervalDropdown = (DropDownList)this.findPaneOfTypeByID("intervals", DropDownList.class);
        intervalDropdown.setHandler(this::onDropDownListChanged);
        intervalDropdown.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return INTERVAL.size();
            }

            public String getLabel(int index) {
                return Component.m_237115_((String)((String)INTERVAL.keySet().toArray()[index])).getString();
            }
        });
        intervalDropdown.setSelectedIndex(new ArrayList<String>(INTERVAL.keySet()).indexOf(this.selectedInterval));
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        String temp = (String)INTERVAL.keySet().toArray()[dropDownList.getSelectedIndex()];
        if (!temp.equals(this.selectedInterval)) {
            this.selectedInterval = temp;
            this.updateStats();
        }
    }

    private void hideZeroClicked(@NotNull Button button) {
        ButtonImage hideButton = (ButtonImage)this.findPaneOfTypeByID(TAG_BUTTON_HIDEZERO, ButtonImage.class);
        boolean bl = this.hideZeroStats = !this.hideZeroStats;
        if (this.hideZeroStats) {
            hideButton.setImage(new ResourceLocation(TEXTURE_ASSIGN_ON_NORMAL), true);
            hideButton.setImageDisabled(new ResourceLocation(TEXTURE_ASSIGN_ON_DISABLED), true);
        } else {
            hideButton.setImage(new ResourceLocation(TEXTURE_ASSIGN_OFF_NORMAL), true);
            hideButton.setImageDisabled(new ResourceLocation(TEXTURE_ASSIGN_OFF_DISABLED), true);
        }
        this.updateStats();
    }

    static {
        INTERVAL.put("com.minecolonies.coremod.gui.interval.yesterday", 1);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.lastweek", 7);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.100days", 100);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.alltime", -1);
    }
}

