/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.moduleviews.MinerGuardAssignModuleView;
import com.minecolonies.core.colony.buildings.moduleviews.SettingsModuleView;
import com.minecolonies.core.network.messages.server.colony.building.guard.GuardSetMinePosMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class WindowMineGuardModule
extends AbstractModuleWindow<MinerGuardAssignModuleView> {
    private static final String LIST_GUARDS = "guards";
    private static final String BUTTON_ASSIGNGUARD = "assignGuard";
    private final List<ICitizenDataView> guardsInfo = new ArrayList<ICitizenDataView>();
    private final ScrollingList guardsList = (ScrollingList)this.findPaneOfTypeByID("guards", ScrollingList.class);
    private int assignedGuards;

    public WindowMineGuardModule(MinerGuardAssignModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutguardlist.xml"));
        this.pullGuardsFromHut();
        this.registerButton(BUTTON_ASSIGNGUARD, this::assignGuardClicked);
    }

    private void assignGuardClicked(Button button) {
        int guardRow = this.guardsList.getListElementIndexByPane((Pane)button);
        ICitizenDataView guard = this.guardsInfo.get(guardRow);
        if (guard != null) {
            AbstractBuildingGuards.View guardbuilding = (AbstractBuildingGuards.View)this.buildingView.getColony().getBuilding(guard.getWorkBuilding());
            if (guardbuilding.getMinePos() == null) {
                if (this.assignedGuards < this.getMaxGuards()) {
                    Network.getNetwork().sendToServer(new GuardSetMinePosMessage(guardbuilding, this.buildingView.getPosition()));
                    button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.buttonunassign"));
                    guardbuilding.setMinePos(this.buildingView.getPosition());
                    ++this.assignedGuards;
                }
            } else if (guardbuilding.getMinePos().equals((Object)this.buildingView.getPosition())) {
                Network.getNetwork().sendToServer(new GuardSetMinePosMessage(guardbuilding));
                button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.buttonassign"));
                guardbuilding.setMinePos(null);
                --this.assignedGuards;
            }
        }
        this.pullGuardsFromHut();
    }

    private void pullGuardsFromHut() {
        if (this.buildingView.getColony().getBuilding(this.buildingView.getID()) != null) {
            this.guardsInfo.clear();
            this.assignedGuards = 0;
            List buildings = this.buildingView.getColony().getBuildings().stream().filter(entry -> entry instanceof AbstractBuildingGuards.View && entry.getModuleViewByType(SettingsModuleView.class).getSetting(AbstractBuildingGuards.GUARD_TASK).getValue().equals("com.minecolonies.core.guard.setting.patrol_mine")).collect(Collectors.toList());
            for (IBuildingView building : buildings) {
                AbstractBuildingGuards.View guardbuilding = (AbstractBuildingGuards.View)building;
                if (guardbuilding.getMinePos() != null && guardbuilding.getMinePos().equals((Object)this.buildingView.getPosition())) {
                    ++this.assignedGuards;
                }
                for (Integer citizenId : guardbuilding.getGuards()) {
                    this.guardsInfo.add(this.buildingView.getColony().getCitizen(citizenId));
                }
            }
            if (this.guardsInfo.isEmpty()) {
                ((Text)this.findPaneOfTypeByID("noguardwarning", Text.class)).setVisible(true);
            } else {
                ((Text)this.findPaneOfTypeByID("noguardwarning", Text.class)).setVisible(false);
            }
        }
    }

    public int getMaxGuards() {
        switch (this.buildingView.getBuildingLevel()) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return 0;
    }

    public void onOpened() {
        super.onOpened();
        this.guardsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowMineGuardModule.this.guardsInfo.size();
            }

            public void updateElement(int i, Pane pane) {
                ICitizenDataView citizen = WindowMineGuardModule.this.guardsInfo.get(i);
                if (citizen != null) {
                    IBuildingView building = WindowMineGuardModule.this.buildingView.getColony().getBuilding(citizen.getWorkBuilding());
                    if (building instanceof AbstractBuildingGuards.View) {
                        ((Text)pane.findPaneOfTypeByID("guardName", Text.class)).setText(Component.m_237113_((String)citizen.getName()));
                        AbstractBuildingGuards.View guardbuilding = (AbstractBuildingGuards.View)building;
                        Button button = (Button)pane.findPaneOfTypeByID(WindowMineGuardModule.BUTTON_ASSIGNGUARD, Button.class);
                        if (guardbuilding.getMinePos() == null) {
                            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.buttonassign"));
                            if (WindowMineGuardModule.this.assignedGuards >= WindowMineGuardModule.this.getMaxGuards()) {
                                button.setEnabled(false);
                            } else {
                                button.setEnabled(true);
                            }
                        } else if (guardbuilding.getMinePos().equals((Object)WindowMineGuardModule.this.buildingView.getPosition())) {
                            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.buttonunassign"));
                        } else {
                            button.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.buttonassign"));
                            button.setEnabled(false);
                        }
                    }
                } else {
                    Button button = (Button)pane.findPaneOfTypeByID(WindowMineGuardModule.BUTTON_ASSIGNGUARD, Button.class);
                    button.setEnabled(false);
                }
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullGuardsFromHut();
    }
}

