/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Gradient;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.core.network.messages.server.colony.building.worker.AddRemoveRecipeMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.ChangeRecipePriorityMessage;
import com.minecolonies.core.network.messages.server.colony.building.worker.ToggleRecipeMessage;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class WindowListRecipes
extends AbstractModuleWindow<CraftingModuleView> {
    private static final String RECIPE_LIST = "recipes";
    private static final String RECIPE_STATUS = "recipestatus";
    private static final String OUTPUT_ICON = "output";
    private static final String RESOURCE = "res%d";
    private final ScrollingList recipeList = (ScrollingList)this.findPaneOfTypeByID("recipes", ScrollingList.class);
    private static final String BUTTON_CRAFTING = "crafting";
    private final Text recipeStatus = (Text)this.findPaneOfTypeByID("recipestatus", Text.class);
    private int lifeCount = 0;

    public WindowListRecipes(CraftingModuleView module) {
        super(module, new ResourceLocation("minecolonies", "gui/layouthuts/layoutlistrecipes.xml"));
        ((ButtonImage)this.findPaneOfTypeByID(BUTTON_CRAFTING, ButtonImage.class)).setVisible(module.isRecipeAlterationAllowed());
        ((Text)this.findPaneOfTypeByID(RECIPE_STATUS, Text.class)).setVisible(module.isRecipeAlterationAllowed());
        super.registerButton(BUTTON_CRAFTING, this::craftingClicked);
        super.registerButton("remove", this::removeClicked);
        super.registerButton("up", this::forwardClicked);
        super.registerButton("down", this::backwardClicked);
        super.registerButton("toggle", this::toggleRecipe);
    }

    private void toggleRecipe(Button button) {
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        ((CraftingModuleView)this.moduleView).toggle(row);
        Network.getNetwork().sendToServer(new ToggleRecipeMessage(this.buildingView, row, ((CraftingModuleView)this.moduleView).getProducer().getRuntimeID()));
    }

    private void backwardClicked(Button button) {
        boolean shift = InputConstants.m_84830_((long)this.mc.m_91268_().m_85439_(), (int)340);
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        ((CraftingModuleView)this.moduleView).switchOrder(row, row + 1, shift);
        Network.getNetwork().sendToServer(new ChangeRecipePriorityMessage(this.buildingView, row, false, ((CraftingModuleView)this.moduleView).getProducer().getRuntimeID(), shift));
        this.recipeList.refreshElementPanes();
    }

    private void forwardClicked(Button button) {
        boolean shift = InputConstants.m_84830_((long)this.mc.m_91268_().m_85439_(), (int)340);
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        ((CraftingModuleView)this.moduleView).switchOrder(row, row - 1, shift);
        Network.getNetwork().sendToServer(new ChangeRecipePriorityMessage(this.buildingView, row, true, ((CraftingModuleView)this.moduleView).getProducer().getRuntimeID(), shift));
        this.recipeList.refreshElementPanes();
    }

    private void removeClicked(Button button) {
        int row = this.recipeList.getListElementIndexByPane((Pane)button);
        IRecipeStorage data = ((CraftingModuleView)this.moduleView).getRecipes().get(row);
        Network.getNetwork().sendToServer(new AddRemoveRecipeMessage(this.buildingView, true, data, ((CraftingModuleView)this.moduleView).getProducer().getRuntimeID()));
    }

    public void craftingClicked() {
        if (!((CraftingModuleView)this.moduleView).isRecipeAlterationAllowed()) {
            return;
        }
        ((CraftingModuleView)this.moduleView).openCraftingGUI();
    }

    public void onOpened() {
        this.recipeList.enable();
        this.recipeList.show();
        this.recipeList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((CraftingModuleView)WindowListRecipes.this.moduleView).getRecipes().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                @NotNull IRecipeStorage recipe = ((CraftingModuleView)WindowListRecipes.this.moduleView).getRecipes().get(index);
                ItemIcon icon = (ItemIcon)rowPane.findPaneOfTypeByID(WindowListRecipes.OUTPUT_ICON, ItemIcon.class);
                List<ItemStack> displayStacks = recipe.getRecipeType().getOutputDisplayStacks();
                icon.setItem(displayStacks.get(WindowListRecipes.this.lifeCount / 30 % displayStacks.size()));
                Button removeButton = (Button)rowPane.findPaneOfTypeByID("remove", Button.class);
                if (removeButton != null) {
                    if (((CraftingModuleView)WindowListRecipes.this.moduleView).isRecipeAlterationAllowed()) {
                        removeButton.on();
                        if (recipe.getRecipeSource() != null && !Screen.m_96637_()) {
                            removeButton.disable();
                            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237110_((String)"com.minecolonies.coremod.gui.workerhuts.removebuiltin", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.control")}))).hoverPane((Pane)removeButton).build();
                        } else {
                            removeButton.setHoverPane(null);
                        }
                    } else {
                        removeButton.off();
                    }
                }
                Text intermediate = (Text)rowPane.findPaneOfTypeByID("intermediate", Text.class);
                intermediate.setVisible(false);
                if (recipe.getRequiredTool() != ModEquipmentTypes.none.get()) {
                    intermediate.setText(recipe.getRequiredTool().getDisplayName());
                    intermediate.setVisible(true);
                } else if (recipe.getIntermediate() != Blocks.f_50016_) {
                    intermediate.setText(recipe.getIntermediate().m_49954_());
                }
                if (((CraftingModuleView)WindowListRecipes.this.moduleView).isDisabled(recipe)) {
                    ((Gradient)rowPane.findPaneOfTypeByID("gradient", Gradient.class)).setVisible(true);
                    ((Button)rowPane.findPaneOfTypeByID("toggle", Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.recipe.enable"));
                    ((Button)rowPane.findPaneOfTypeByID("toggle", Button.class)).setVisible(((CraftingModuleView)WindowListRecipes.this.moduleView).getActiveRecipes() < ((CraftingModuleView)WindowListRecipes.this.moduleView).getMaxRecipes());
                } else {
                    ((Gradient)rowPane.findPaneOfTypeByID("gradient", Gradient.class)).setVisible(false);
                    ((Button)rowPane.findPaneOfTypeByID("toggle", Button.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.recipe.disable"));
                    ((Button)rowPane.findPaneOfTypeByID("toggle", Button.class)).setVisible(true);
                }
                if (recipe.getInput().size() < 4) {
                    for (int i = 0; i < 9; ++i) {
                        if (i < recipe.getInput().size()) {
                            ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(i)));
                            continue;
                        }
                        ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(ItemStack.f_41583_);
                    }
                } else if (recipe.getInput().size() == 4) {
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 1), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(0)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 2), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(1)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 3), ItemIcon.class)).setItem(ItemStack.f_41583_);
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 4), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(2)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, 5), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(3)));
                    for (int i = 6; i < 9; ++i) {
                        ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(ItemStack.f_41583_);
                    }
                } else {
                    for (int i = 0; i < Math.min(9, recipe.getInput().size()); ++i) {
                        ((ItemIcon)rowPane.findPaneOfTypeByID(String.format(WindowListRecipes.RESOURCE, i + 1), ItemIcon.class)).setItem(WindowListRecipes.this.getStackWithCount(recipe.getInput().get(i)));
                    }
                }
            }
        });
    }

    private ItemStack getStackWithCount(ItemStorage storage) {
        ItemStack displayItem = storage.getItemStack();
        displayItem.m_41764_(storage.getAmount());
        return displayItem;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!Screen.m_96638_()) {
            ++this.lifeCount;
        }
        this.recipeStatus.setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.workerhuts.recipestatus", (Object[])new Object[]{((CraftingModuleView)this.moduleView).getActiveRecipes(), ((CraftingModuleView)this.moduleView).getMaxRecipes()}));
        ((ScrollingList)this.window.findPaneOfTypeByID(RECIPE_LIST, ScrollingList.class)).refreshElementPanes();
    }
}

