/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.core.colony.buildings.moduleviews.WarehouseOptionsModuleView;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import com.minecolonies.core.network.messages.server.colony.building.warehouse.SortWarehouseMessage;
import com.minecolonies.core.network.messages.server.colony.building.warehouse.UpgradeWarehouseMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class WarehouseOptionsModuleWindow
extends AbstractModuleWindow<WarehouseOptionsModuleView> {
    private static final int BUILDING_LEVEL_FOR_SORTING = 3;
    private static final String SORT_WAREHOUSE_BUTTON = "sort";
    private boolean lockUpgrade = false;

    public WarehouseOptionsModuleWindow(WarehouseOptionsModuleView module) {
        super(module, new ResourceLocation("minecolonies", "gui/layouthuts/layoutwarehouseoptions.xml"));
        this.registerButton("resourceAdd", this::transferItems);
        this.registerButton(SORT_WAREHOUSE_BUTTON, this::sortWarehouse);
    }

    public void onOpened() {
        if (this.buildingView.getBuildingLevel() < 3) {
            ButtonImage sortButton = (ButtonImage)this.findPaneOfTypeByID(SORT_WAREHOUSE_BUTTON, ButtonImage.class);
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237110_((String)"com.minecolonies.coremod.gui.warehouse.sort.disabled.1", (Object[])new Object[]{3}))).appendNL(Component.m_237110_((String)"com.minecolonies.coremod.gui.warehouse.sort.disabled.2", (Object[])new Object[]{3}))).hoverPane((Pane)sortButton).build();
            sortButton.disable();
        }
        super.onOpened();
        this.updateResourcePane();
        Network.getNetwork().sendToServer(new MarkBuildingDirtyMessage(this.buildingView));
    }

    private void updateResourcePane() {
        BuildingBuilderResource resource = new BuildingBuilderResource(new ItemStack((ItemLike)Blocks.f_50268_, 1), 1);
        Inventory inventory = this.mc.f_91074_.m_150109_();
        boolean isCreative = this.mc.f_91074_.m_7500_();
        int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)inventory), resource.getItem());
        resource.setPlayerAmount(amountToSet);
        Text resourceLabel = (Text)this.findPaneOfTypeByID("resourceName", Text.class);
        Text resourceMissingLabel = (Text)this.findPaneOfTypeByID("resourceMissing", Text.class);
        Text neededLabel = (Text)this.findPaneOfTypeByID("resourceAvailableNeeded", Text.class);
        Button addButton = (Button)this.findPaneOfTypeByID("resourceAdd", Button.class);
        BuildingBuilderResource.RessourceAvailability availability = resource.getAvailabilityStatus();
        if (((WarehouseOptionsModuleView)this.moduleView).getStorageUpgradeLevel() >= 3 || this.buildingView.getBuildingLevel() < this.buildingView.getBuildingMaxLevel() || this.lockUpgrade) {
            availability = BuildingBuilderResource.RessourceAvailability.NOT_NEEDED;
        }
        ((Text)this.findPaneOfTypeByID("upgradeProgress", Text.class)).setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.xofz", (Object[])new Object[]{((WarehouseOptionsModuleView)this.moduleView).getStorageUpgradeLevel(), 3}));
        switch (availability) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColors(WindowBuilderResModule.RED);
                resourceMissingLabel.setColors(WindowBuilderResModule.RED);
                neededLabel.setColors(WindowBuilderResModule.RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColors(WindowBuilderResModule.RED);
                resourceMissingLabel.setColors(WindowBuilderResModule.RED);
                neededLabel.setColors(WindowBuilderResModule.RED);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColors(WindowBuilderResModule.DARKGREEN);
                resourceMissingLabel.setColors(WindowBuilderResModule.DARKGREEN);
                neededLabel.setColors(WindowBuilderResModule.DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColors(WindowBuilderResModule.BLACK);
                resourceMissingLabel.setColors(WindowBuilderResModule.BLACK);
                neededLabel.setColors(WindowBuilderResModule.BLACK);
                if (this.buildingView.getBuildingLevel() >= this.buildingView.getBuildingMaxLevel()) break;
                resourceLabel.hide();
                resourceMissingLabel.hide();
                neededLabel.hide();
                addButton.setText(Component.m_237113_((String)"X").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_RED)));
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(Component.m_237110_((String)"com.minecolonies.coremod.gui.warehouse.upgrade.disabled.1", (Object[])new Object[]{this.buildingView.getBuildingMaxLevel()}))).appendNL(Component.m_237110_((String)"com.minecolonies.coremod.gui.warehouse.upgrade.disabled.2", (Object[])new Object[]{this.buildingView.getBuildingMaxLevel()}))).hoverPane((Pane)addButton).build();
            }
        }
        resourceLabel.setText(Component.m_237113_((String)resource.getName()));
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setText(Component.m_237113_((String)Integer.toString(missing)));
        } else {
            resourceMissingLabel.clearText();
        }
        neededLabel.setText(Component.m_237113_((String)(resource.getAvailable() + " / " + resource.getAmount())));
        ((Text)this.findPaneOfTypeByID("resourceQuantity", Text.class)).setText(Component.m_237113_((String)Integer.toString(resource.getAmount() - resource.getAvailable())));
        if (this.buildingView.getBuildingLevel() >= this.buildingView.getBuildingMaxLevel()) {
            ItemStack resourceStackOfOne = new ItemStack((ItemLike)resource.getItem(), 1);
            resourceStackOfOne.m_41751_(resource.getItemStack().m_41783_());
            ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resourceStackOfOne);
        }
    }

    private void transferItems() {
        Network.getNetwork().sendToServer(new UpgradeWarehouseMessage(this.buildingView));
        ((WarehouseOptionsModuleView)this.moduleView).incrementStorageUpgrade();
        this.lockUpgrade = true;
        this.updateResourcePane();
    }

    private void sortWarehouse() {
        if (this.buildingView.getBuildingLevel() >= 3) {
            Network.getNetwork().sendToServer(new SortWarehouseMessage(this.buildingView));
            MessageUtils.format("com.minecolonies.coremod.gui.warehouse.sorted", new Object[0]).sendTo(new Player[]{Minecraft.m_91087_().f_91074_});
        }
    }
}

