/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.map;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.blockui.views.View;
import com.ldtteam.blockui.views.ZoomDragView;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.client.render.modeltype.ISimpleModelType;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IStackBasedTask;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.map.ColonySize;
import com.minecolonies.core.client.gui.map.MinecraftMap;
import com.minecolonies.core.client.gui.map.ZoomDragMap;
import com.minecolonies.core.client.gui.questlog.Constants;
import com.minecolonies.core.client.render.worldevent.HighlightManager;
import com.minecolonies.core.client.render.worldevent.highlightmanager.CitizenRenderData;
import com.minecolonies.core.colony.buildings.views.LivingBuildingView;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.colony.requestsystem.locations.StaticLocation;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.network.messages.client.colony.ColonyListMessage;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.mojang.authlib.GameProfile;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class WindowColonyMap
extends AbstractWindowSkeleton {
    public static final int HIGHLIGHT_RANGE = 2;
    private static final double COLONY_DETAIL_SCALE = 0.3;
    private static List<ColonyListMessage.ColonyInfo> colonies = new ArrayList<ColonyListMessage.ColonyInfo>();
    private final BlockPos playerPos;
    private final ZoomDragMap dragView;
    private final boolean atTownHall;
    private Map<ICitizenDataView, View> citizens = new HashMap<ICitizenDataView, View>();
    private Map<IBuildingView, MapDecoration> buildings = new HashMap<IBuildingView, MapDecoration>();
    private Map<ColonyListMessage.ColonyInfo, View> coloniesImages = new HashMap<ColonyListMessage.ColonyInfo, View>();
    private List<MinecraftMap> maps = new ArrayList<MinecraftMap>();
    private IBuildingView building;
    private final DecimalFormat scaleformet = new DecimalFormat("##");
    private double currentScale = 0.0;
    private boolean hasMaps = false;

    public WindowColonyMap(boolean atTownHall, IBuildingView building) {
        super(new ResourceLocation("minecolonies", "gui/map/windowcolonymap.xml"));
        this.atTownHall = atTownHall;
        this.building = building;
        this.playerPos = new BlockPos(Minecraft.m_91087_().f_91074_.m_20183_().m_123341_(), 0, Minecraft.m_91087_().f_91074_.m_20183_().m_123343_());
        ZoomDragView parent = (ZoomDragView)this.findPaneOfTypeByID("dragView", ZoomDragView.class);
        this.dragView = new ZoomDragMap();
        this.dragView.setSize(parent.getWidth(), parent.getHeight());
        this.dragView.setPosition(parent.getX(), parent.getY());
        this.dragView.enable();
        this.dragView.setVisible(true);
        this.dragView.setFocus();
        this.dragView.setWindow(this);
        parent.addChild((Pane)this.dragView);
        if (this.addMaps()) {
            this.addCitizens(building.getColony());
            this.addCenterPos();
        }
        if (atTownHall) {
            this.registerButton("exit", () -> building.openGui(false));
        } else {
            this.findPaneByID("inventory").hide();
            this.registerButton("exit", this::close);
        }
        this.registerButton("inventory", this::inventoryClicked);
        Network.getNetwork().sendToServer(new ColonyListMessage());
    }

    private void inventoryClicked() {
        Network.getNetwork().sendToServer(new OpenInventoryMessage(this.building));
    }

    private boolean addMaps() {
        for (MinecraftMap map : this.maps) {
            this.dragView.removeChild(map);
            map.close();
        }
        this.maps.clear();
        for (MapItemSavedData mapData : ((BuildingTownHall.View)this.building).getMapDataList()) {
            if (mapData.f_77890_ != 0) continue;
            this.hasMaps = true;
            MinecraftMap mapImage = new MinecraftMap();
            mapImage.setPosition(this.worldPosToUIPos(new BlockPos(mapData.f_256718_ - 64, 0, 0)).m_123341_(), this.worldPosToUIPos(new BlockPos(0, 0, mapData.f_256789_ - 64)).m_123343_());
            mapImage.setID("map" + mapData.f_256718_ + "-" + mapData.f_256789_);
            mapImage.setMapData(mapData);
            mapImage.setSize((int)(512.0 * this.currentScale), (int)(512.0 * this.currentScale));
            this.dragView.addChildFirst(mapImage);
            this.maps.add(mapImage);
        }
        this.findPaneByID("warning").setVisible(!this.hasMaps);
        return this.hasMaps;
    }

    public static void setColonies(List<ColonyListMessage.ColonyInfo> colonyInfo) {
        colonies = colonyInfo;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.hasMaps) {
            for (Map.Entry<ICitizenDataView, View> entry : this.citizens.entrySet()) {
                EntityCitizen citizen = (EntityCitizen)this.building.getColony().getWorld().m_6815_(entry.getKey().getEntityId());
                if (citizen == null) continue;
                entry.getValue().setPosition(this.worldPosToUIPos(citizen.m_20183_()).m_123341_(), this.worldPosToUIPos(citizen.m_20183_()).m_123343_());
            }
            for (Map.Entry<Object, Object> entry : this.buildings.entrySet()) {
                if (((MapDecoration)entry.getValue()).rangeBox == null) continue;
                if (((MapDecoration)entry.getValue()).icon.wasCursorInPane()) {
                    ((MapDecoration)entry.getValue()).rangeBox.show();
                    continue;
                }
                ((MapDecoration)entry.getValue()).rangeBox.hide();
            }
            for (Player player : Minecraft.m_91087_().f_91073_.m_6907_()) {
                if (!this.building.getColony().isCoordInColony((Level)Minecraft.m_91087_().f_91073_, player.m_20183_())) continue;
                Image playerImage = (Image)this.findPaneOfTypeByID(player.m_20149_(), Image.class);
                if (playerImage == null) {
                    ResourceLocation resourceLocation = OutOfJarResourceLocation.ofMinecraftSkin((Minecraft)Minecraft.m_91087_(), (GameProfile)Minecraft.m_91087_().m_91094_().m_92548_(), null);
                    if (resourceLocation == null) continue;
                    playerImage = new Image();
                    playerImage.setID(player.m_20149_());
                    playerImage.setImage(resourceLocation, 8, 8, 8, 8);
                    playerImage.setSize(16, 16);
                    this.dragView.addChild((Pane)playerImage);
                    ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)playerImage).append(Component.m_237113_((String)player.m_5446_().getString()))).build();
                }
                playerImage.setPosition(this.worldPosToUIPos(player.m_20183_()).m_123341_(), this.worldPosToUIPos(player.m_20183_()).m_123343_());
            }
            if (this.currentScale != this.dragView.getScale()) {
                this.currentScale = this.dragView.getScale();
                this.updateScale();
            }
        }
    }

    private void updateScale() {
        for (ColonyListMessage.ColonyInfo colonyInfo : colonies) {
            this.updateColonyInfoImage(colonyInfo);
        }
        for (ColonyListMessage.ColonyInfo colonyInfo : colonies) {
            this.updateColonyInfoImage(colonyInfo);
        }
        for (IBuildingView iBuildingView : this.building.getColony().getBuildings()) {
            this.updateBuildingView(iBuildingView);
        }
        if (this.currentScale < 0.3) {
            for (Map.Entry entry : this.buildings.entrySet()) {
                ((MapDecoration)entry.getValue()).icon.off();
            }
            for (Map.Entry entry : this.citizens.entrySet()) {
                ((View)entry.getValue()).off();
            }
        } else {
            for (Map.Entry entry : this.buildings.entrySet()) {
                ((MapDecoration)entry.getValue()).icon.on();
            }
            for (Map.Entry entry : this.citizens.entrySet()) {
                ((View)entry.getValue()).on();
            }
            for (Map.Entry entry : this.coloniesImages.entrySet()) {
                ((View)entry.getValue()).off();
            }
        }
        this.addMaps();
        ((Text)this.findPaneOfTypeByID("scale", Text.class)).setText(Component.m_237113_((String)(this.scaleformet.format(1.0 / this.currentScale) + "x")));
    }

    private void updateColonyInfoImage(ColonyListMessage.ColonyInfo colonyInfo) {
        View colonyPane = this.coloniesImages.get(colonyInfo);
        if (colonyPane == null) {
            colonyPane = ColonySize.createViewForInfo(colonyInfo);
            colonyPane.setID(colonyInfo.getId() + colonyInfo.getOwner());
            this.dragView.addChild((Pane)colonyPane);
            this.coloniesImages.put(colonyInfo, colonyPane);
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)colonyPane).append(Component.m_237113_((String)("Owner:" + colonyInfo.getOwner())))).appendNL(Component.m_237113_((String)("Coordinates: " + colonyInfo.getCenter().m_123341_() + "X, " + colonyInfo.getCenter().m_123343_() + "Z")))).appendNL(Component.m_237113_((String)("Citizens: " + colonyInfo.getCitizencount())))).build();
        }
        if (this.currentScale < 0.3) {
            colonyPane.setPosition(this.worldPosToUIPos(colonyInfo.getCenter()).m_123341_() - colonyPane.getWidth() / 2, this.worldPosToUIPos(colonyInfo.getCenter()).m_123343_() - colonyPane.getHeight() / 2);
            colonyPane.on();
        } else {
            colonyPane.off();
        }
    }

    private void addCenterPos() {
        Image citizenImage = new Image();
        if (this.atTownHall) {
            citizenImage.setImage(new ResourceLocation("minecolonies", "textures/gui/red_wax_home.png"), false);
            citizenImage.setSize(16, 16);
            citizenImage.setPosition(this.worldPosToUIPos(this.playerPos).m_123341_(), this.worldPosToUIPos(this.playerPos).m_123343_());
            this.dragView.addChild((Pane)citizenImage);
        }
    }

    private void updateBuildingView(IBuildingView buildingView) {
        MapDecoration buildingDecorations = this.buildings.get(buildingView);
        if (buildingDecorations == null) {
            LivingBuildingView home;
            int n;
            Object home2;
            ItemIcon uiBuilding = new ItemIcon();
            Box box = null;
            Box houseWithCapacity = null;
            Image statusImage = null;
            uiBuilding.setID(buildingView.getID().m_123344_());
            uiBuilding.setSize(11 + buildingView.getBuildingLevel(), 11 + buildingView.getBuildingLevel());
            ItemStack item = buildingView.getBuildingType().getBuildingBlock().m_5456_().m_7968_();
            uiBuilding.setItem(item);
            this.dragView.addChild((Pane)uiBuilding);
            AbstractTextBuilder.TooltipBuilder tooltip = PaneBuilders.tooltipBuilder();
            AbstractTextBuilder.TooltipBuilder tooltipBuilder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)tooltip.hoverPane((Pane)uiBuilding).append(Component.m_237115_((String)buildingView.getBuildingDisplayName()))).append(Component.m_237113_((String)(" : " + buildingView.getBuildingLevel())))).appendNL(Component.m_237113_((String)("Coordinates: " + buildingView.getID().m_123341_() + "X, " + buildingView.getID().m_123343_() + "Z")));
            if (buildingView instanceof LivingBuildingView) {
                home2 = (LivingBuildingView)buildingView;
                n = ((LivingBuildingView)home2).getResidents().size();
            } else {
                n = buildingView.getAllAssignedCitizens().size();
            }
            tooltipBuilder.appendNL(Component.m_237113_((String)("Citizens: " + n)));
            home2 = buildingView.getAllAssignedCitizens().iterator();
            while (home2.hasNext()) {
                int id = (Integer)home2.next();
                ICitizenDataView dataView = this.building.getColony().getCitizen(id);
                if (dataView == null) continue;
                tooltip.appendNL(Component.m_237113_((String)dataView.getName()));
            }
            ImmutableList<IRequest<?>> playerResolvedRequests = this.getPlayerResolvedRequestsForBuilding(buildingView);
            if (playerResolvedRequests.size() > 0) {
                statusImage = new Image();
                statusImage.setImage(new ResourceLocation("minecolonies:textures/icons/information.png"), false);
                statusImage.setSize(6, 6);
                BlockPos uiPos = this.worldPosToUIPos(buildingView.getPosition());
                statusImage.setPosition(uiPos.m_123341_() - 4, uiPos.m_123342_() - 4);
                statusImage.setVisible(true);
                AbstractTextBuilder.TooltipBuilder statustip = PaneBuilders.tooltipBuilder();
                statustip.hoverPane((Pane)statusImage);
                statustip.append(Component.m_237115_((String)"com.minecolonies.core.item.colonymap.playerresolvedrequests"));
                for (IRequest request : playerResolvedRequests) {
                    int count = -1;
                    MutableComponent tipText = null;
                    if (request instanceof IStackBasedTask) {
                        IStackBasedTask stackRequest = (IStackBasedTask)((Object)request);
                        count = stackRequest.getDisplayCount();
                        tipText = stackRequest.getDisplayPrefix();
                    } else {
                        tipText = Component.m_237113_((String)request.getLongDisplayString().getString().replace("\u00a7f", ""));
                    }
                    statustip.appendNL((Component)tipText);
                    if (count <= 0) continue;
                    statustip.append(Component.m_237113_((String)(": " + count)));
                }
                this.dragView.addChild((Pane)statusImage);
                statustip.build();
                tooltip.appendNL(Component.m_237110_((String)"com.minecolonies.core.item.colonymap.playerresolvedrequests.count", (Object[])new Object[]{playerResolvedRequests.size()}));
            }
            tooltip.build();
            uiBuilding.setVisible(true);
            if (buildingView instanceof LivingBuildingView && (home = (LivingBuildingView)buildingView).getResidents().size() < buildingView.getBuildingLevel() && buildingView.getRange() == 0) {
                double pctFull = Math.max(0.0, Math.min(1.0, (double)home.getResidents().size() / (double)buildingView.getBuildingLevel()));
                houseWithCapacity = new Box();
                BlockPos uiPos = this.worldPosToUIPos(buildingView.getPosition());
                houseWithCapacity.setLineWidth(2);
                houseWithCapacity.setColor(MapDecoration.getRedFromRange(pctFull), MapDecoration.getGreenFromRange(pctFull), 33);
                houseWithCapacity.setPosition(uiPos.m_123341_(), uiPos.m_123343_());
                houseWithCapacity.setSize(uiBuilding.getWidth(), uiBuilding.getHeight());
                this.dragView.addChild((Pane)houseWithCapacity);
            }
            if (buildingView.getRange() != 0) {
                int range = buildingView.getRange();
                BlockPos UIPos1 = this.worldPosToUIPos(buildingView.getPosition().m_7918_(-range, 0, -range));
                BlockPos UIPos2 = this.worldPosToUIPos(buildingView.getPosition().m_7918_(range, 0, range));
                box = new Box();
                box.setLineWidth(2);
                box.setColor(255, 0, 0);
                box.setPosition(UIPos1.m_123341_(), UIPos1.m_123343_());
                box.setSize(UIPos2.m_123341_() - UIPos1.m_123341_(), UIPos2.m_123343_() - UIPos1.m_123343_());
                box.hide();
                this.dragView.addChild((Pane)box);
            }
            this.dragView.addChild((Pane)uiBuilding);
            buildingDecorations = new MapDecoration(uiBuilding, box, houseWithCapacity, statusImage);
            this.buildings.put(buildingView, buildingDecorations);
        }
        BlockPos newPos = this.worldPosToUIPos(buildingView.getID());
        buildingDecorations.icon.setPosition(newPos.m_123341_(), newPos.m_123343_());
        if (buildingDecorations.rangeBox != null) {
            int range = buildingView.getRange();
            BlockPos UIPos1 = this.worldPosToUIPos(buildingView.getPosition().m_7918_(-range, 0, -range));
            BlockPos UIPos2 = this.worldPosToUIPos(buildingView.getPosition().m_7918_(range, 0, range));
            buildingDecorations.rangeBox.setPosition(UIPos1.m_123341_(), UIPos1.m_123343_());
            buildingDecorations.rangeBox.setSize(UIPos2.m_123341_() - UIPos1.m_123341_(), UIPos2.m_123343_() - UIPos1.m_123343_());
        }
        if (buildingDecorations.highlightBox != null) {
            BlockPos UIPos1 = this.worldPosToUIPos(buildingView.getPosition());
            buildingDecorations.highlightBox.setPosition(UIPos1.m_123341_(), UIPos1.m_123343_());
            buildingDecorations.highlightBox.setSize(buildingDecorations.icon.getWidth(), buildingDecorations.icon.getHeight());
        }
        if (buildingDecorations.statusImage != null) {
            BlockPos UIPos1 = this.worldPosToUIPos(buildingView.getPosition());
            buildingDecorations.statusImage.setPosition(UIPos1.m_123341_() - 4, UIPos1.m_123343_() - 4);
        }
    }

    private void addCitizens(IColonyView colony) {
        for (ICitizenDataView data : colony.getCitizens().values()) {
            EntityCitizen citizen = (EntityCitizen)colony.getWorld().m_6815_(data.getEntityId());
            if (citizen == null) continue;
            View citizenView = new View();
            citizenView.setPosition(this.worldPosToUIPos(citizen.m_20183_()).m_123341_(), this.worldPosToUIPos(citizen.m_20183_()).m_123343_());
            ButtonImage citizenImage = new ButtonImage();
            citizenImage.setImage(((ISimpleModelType)IModelTypeRegistry.getInstance().getModelType(citizen.getModelType())).getTextureIcon(citizen), false);
            citizenImage.setSize(4, 4);
            citizenImage.setID("citizen: " + data.getId());
            this.registerButton(citizenImage.getID(), (Button button) -> {
                HighlightManager.addHighlight("mapsearchtracking", "", new CitizenRenderData(citizen.getCivilianID(), Constants.HIGHLIGHT_QUEST_LOG_TRACKER_DURATION));
                SoundUtils.playSuccessSound((Player)this.mc.f_91074_, this.mc.f_91074_.m_20183_());
            });
            AbstractTextBuilder.TooltipBuilder builder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)citizenView).paragraphBreak()).append(citizen.m_5446_());
            if (!data.getJob().isEmpty()) {
                citizenImage.setSize(8, 8);
                ((AbstractTextBuilder.TooltipBuilder)builder.newLine()).append(Component.m_237110_((String)"com.minecolonies.coremod.gui.citizen.job.label", (Object[])new Object[]{LanguageHandler.format((String)data.getJob(), (Object[])new Object[0])}));
            }
            citizenView.setSize(citizenImage.getWidth(), citizenImage.getHeight());
            citizenView.addChild((Pane)citizenImage);
            this.dragView.addChild((Pane)citizenView);
            if (data.hasVisibleStatus()) {
                Image interactionImage = new Image();
                interactionImage.setImage(data.getStatusIcon(), false);
                interactionImage.setSize(6, 6);
                interactionImage.setPosition(-3, -3);
                citizenView.addChild((Pane)interactionImage);
                citizenView.setSize(citizenView.getWidth() + 6, citizenView.getHeight() + 6);
                if (data.hasBlockingInteractions()) {
                    MutableComponent inquiry = (MutableComponent)data.getOrderedInteractions().get(0).getInquiry();
                    ((AbstractTextBuilder.TooltipBuilder)builder.newLine()).append(inquiry.m_130940_(ChatFormatting.DARK_RED));
                }
            }
            if (data.isSick()) {
                Image sickIcon = new Image();
                sickIcon.setImage(new ResourceLocation("minecolonies:textures/icons/small_sick_icon.png"), false);
                sickIcon.setSize(4, 8);
                sickIcon.setPosition(3, -3);
                citizenView.addChild((Pane)sickIcon);
                citizenView.setSize(citizenView.getWidth() + 6, citizenView.getHeight() + 6);
            } else if (data.getSaturation() < 6.0) {
                Image saturationIcon = new Image();
                saturationIcon.setImage(Gui.f_279580_, 16, 27, 9, 9);
                saturationIcon.setMapDimensions(256, 256);
                saturationIcon.setSize(9, 9);
                saturationIcon.setPosition(3, -3);
                citizenView.addChild((Pane)saturationIcon);
                citizenView.setSize(citizenView.getWidth() + 6, citizenView.getHeight() + 6);
            }
            ((AbstractTextBuilder.TooltipBuilder)builder.color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
            if (this.citizens.containsKey(data)) {
                this.dragView.removeChild((Pane)this.citizens.get(data));
            }
            this.citizens.put(data, citizenView);
        }
    }

    private BlockPos worldPosToUIPos(BlockPos worldPos) {
        return BlockPos.m_274561_((double)((double)this.dragView.getWidth() / 2.0 - (double)((this.playerPos.m_123341_() - worldPos.m_123341_()) * 4) / Math.max(1.0, Math.log((float)Math.abs(this.playerPos.m_123341_() - worldPos.m_123341_()) / 1000.0f)) * this.currentScale), (double)0.0, (double)((double)this.dragView.getHeight() / 2.0 - (double)((this.playerPos.m_123343_() - worldPos.m_123343_()) * 4) / Math.max(1.0, Math.log((float)Math.abs(this.playerPos.m_123343_() - worldPos.m_123343_()) / 1000.0f)) * this.currentScale));
    }

    public void onClosed() {
        super.onClosed();
        this.maps.forEach(MinecraftMap::close);
    }

    public ImmutableList<IRequest<?>> getPlayerResolvedRequestsForBuilding(IBuildingView buildingView) {
        if (buildingView == null || buildingView.getColony() == null) {
            return ImmutableList.of();
        }
        StaticLocation buildingLocation = new StaticLocation(buildingView.getPosition(), buildingView.getColony().getDimension());
        ArrayList playerResolvedBuildingRequests = Lists.newArrayList();
        if (buildingView == null || buildingView.getColony() == null) {
            return ImmutableList.of();
        }
        IRequestManager requestManager = buildingView.getColony().getRequestManager();
        if (requestManager == null) {
            return ImmutableList.of();
        }
        try {
            IPlayerRequestResolver resolver = requestManager.getPlayerResolver();
            HashSet assigned = new HashSet((Collection<IToken<?>>)resolver.getAllAssignedRequests());
            for (IToken iToken : assigned) {
                IRequest<?> r = requestManager.getRequestForToken(iToken);
                if (r == null || !r.getRequester().getLocation().equals(buildingLocation)) continue;
                playerResolvedBuildingRequests.add(r);
            }
        }
        catch (Exception e) {
            Log.getLogger().warn("Exception trying to retrieve requests:", (Throwable)e);
            requestManager.reset();
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)playerResolvedBuildingRequests);
    }

    public class MapDecoration {
        public ItemIcon icon;
        public Box rangeBox;
        public Box highlightBox;
        public Image statusImage;

        public MapDecoration(ItemIcon icon, Box rangeBox, Box highlightBox, Image statusImage) {
            this.icon = icon;
            this.rangeBox = rangeBox;
            this.highlightBox = highlightBox;
            this.statusImage = statusImage;
        }

        public static int getRedFromRange(double pctFull) {
            int red = pctFull <= 0.5 ? (int)(255.0 * (pctFull / 0.5)) : 255;
            return red;
        }

        public static int getGreenFromRange(double pctFull) {
            int green = pctFull <= 0.5 ? 255 : (int)(255.0 * (1.0 - (pctFull - 0.5) / 0.5));
            return green;
        }
    }
}

