/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.citizen;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.citizen.AbstractWindowCitizen;
import com.minecolonies.core.network.messages.server.colony.UpdateRequestStateMessage;
import com.minecolonies.core.network.messages.server.colony.citizen.TransferItemsToCitizenRequestMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class RequestWindowCitizen
extends AbstractWindowCitizen {
    public static final ResourceLocation WINDOW_ID = new ResourceLocation("minecolonies", "gui/citizen/requests.xml");
    private final Inventory inventory;
    private final boolean isCreative;

    public RequestWindowCitizen(ICitizenDataView citizen) {
        super(citizen, WINDOW_ID);
        this.inventory = this.mc.f_91074_.m_150109_();
        this.isCreative = this.mc.f_91074_.m_7500_();
    }

    public ICitizenDataView getCitizen() {
        return this.citizen;
    }

    @Override
    public boolean canFulFill() {
        return true;
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequestsFromBuilding(IBuildingView building) {
        IRequest<?> request;
        if (building == null) {
            return ImmutableList.of();
        }
        ArrayList requests = new ArrayList();
        for (IToken req : (Collection)building.getOpenRequestsByCitizen().getOrDefault(this.citizen.getId(), Collections.emptyList())) {
            if (req == null || (request = this.colony.getRequestManager().getRequestForToken(req)) == null) continue;
            requests.add(request);
        }
        for (IToken req : (Collection)building.getOpenRequestsByCitizen().getOrDefault(-1, Collections.emptyList())) {
            if (req == null || (request = this.colony.getRequestManager().getRequestForToken(req)) == null) continue;
            requests.add(request);
        }
        return ImmutableList.copyOf(requests);
    }

    @Override
    public void fulfill(@NotNull IRequest<?> tRequest) {
        ItemStack itemStack;
        if (!(tRequest.getRequest() instanceof IDeliverable)) {
            return;
        }
        @NotNull IRequest<?> request = tRequest;
        Predicate<ItemStack> requestPredicate = stack -> ((IDeliverable)request.getRequest()).matches((ItemStack)stack);
        int amount = ((IDeliverable)request.getRequest()).getCount();
        int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((Container)this.inventory), requestPredicate);
        if (!this.isCreative && count <= 0) {
            return;
        }
        if (this.isCreative) {
            itemStack = request.getDisplayStacks().stream().findFirst().orElse(ItemStack.f_41583_);
        } else {
            List<Integer> slots = InventoryUtils.findAllSlotsInItemHandlerWith((IItemHandler)new InvWrapper((Container)this.inventory), requestPredicate);
            int invSize = this.inventory.m_6643_() - 5;
            int slot = -1;
            for (Integer possibleSlot : slots) {
                if (possibleSlot >= invSize) continue;
                slot = possibleSlot;
                break;
            }
            if (slot == -1) {
                MessageUtils.format("<%s> ", new Object[0]).append("com.minecolonies.coremod.general.canttakeequipped", this.citizen.getName()).withPriority(MessageUtils.MessagePriority.IMPORTANT).sendTo(new Player[]{Minecraft.m_91087_().f_91074_});
                return;
            }
            itemStack = this.inventory.m_8020_(slot);
        }
        if (this.citizen.getWorkBuilding() != null) {
            this.colony.getBuilding(this.citizen.getWorkBuilding()).onRequestedRequestComplete(this.colony.getRequestManager(), tRequest);
        }
        Network.getNetwork().sendToServer(new TransferItemsToCitizenRequestMessage(this.colony, this.citizen, itemStack, this.isCreative ? amount : Math.min(amount, count)));
        ItemStack copy = itemStack.m_41777_();
        copy.m_41764_(this.isCreative ? amount : Math.min(amount, count));
        Network.getNetwork().sendToServer(new UpdateRequestStateMessage(this.colony, (IToken<?>)request.getId(), RequestState.OVERRULED, copy));
    }
}

