/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.citizen;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowRequestTree;
import com.minecolonies.core.client.gui.citizen.FamilyWindowCitizen;
import com.minecolonies.core.client.gui.citizen.HappinessWindowCitizen;
import com.minecolonies.core.client.gui.citizen.JobWindowCitizen;
import com.minecolonies.core.client.gui.citizen.MainWindowCitizen;
import com.minecolonies.core.client.gui.citizen.RequestWindowCitizen;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.debug.DebugPlayerManager;
import com.minecolonies.core.debug.gui.DebugWindowCitizen;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class AbstractWindowCitizen
extends AbstractWindowRequestTree {
    protected final ICitizenDataView citizen;

    public AbstractWindowCitizen(ICitizenDataView citizen, ResourceLocation ui) {
        super(IColonyManager.getInstance().getColonyView(citizen.getColonyId(), (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_()), citizen.getWorkBuilding(), ui);
        IBuildingView building;
        this.citizen = citizen;
        this.registerButton("mainTab", () -> new MainWindowCitizen(citizen).open());
        this.registerButton("mainIcon", () -> new MainWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("mainIcon")).build().setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.citizen.main"));
        this.registerButton("requestTab", () -> new RequestWindowCitizen(citizen).open());
        this.registerButton("requestIcon", () -> new RequestWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("requestIcon")).build().setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.citizen.requests"));
        this.registerButton("inventoryTab", () -> Network.getNetwork().sendToServer(new OpenInventoryMessage(this.colony, citizen.getName(), citizen.getEntityId())));
        this.registerButton("inventoryIcon", () -> Network.getNetwork().sendToServer(new OpenInventoryMessage(this.colony, citizen.getName(), citizen.getEntityId())));
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("inventoryIcon")).build().setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.citizen.inventory"));
        this.registerButton("happinessTab", () -> new HappinessWindowCitizen(citizen).open());
        this.registerButton("happinessIcon", () -> new HappinessWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("happinessIcon")).build().setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.citizen.happiness"));
        this.registerButton("familyTab", () -> new FamilyWindowCitizen(citizen).open());
        this.registerButton("familyIcon", () -> new FamilyWindowCitizen(citizen).open());
        PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("familyIcon")).build().setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.citizen.family"));
        if (DebugPlayerManager.hasDebugEnabled((Player)this.mc.f_91074_)) {
            this.findPaneByID("debugTab").setVisible(true);
            this.findPaneByID("debugIcon").setVisible(true);
            this.registerButton("debugTab", () -> new DebugWindowCitizen(citizen).open());
            this.registerButton("debugIcon", () -> new DebugWindowCitizen(citizen).open());
            PaneBuilders.singleLineTooltip((MutableComponent)Component.m_237115_((String)"com.minecolonies.coremod.debug.gui.tabicon"), (Pane)this.findPaneByID("debugIcon"));
        }
        if ((building = this.colony.getBuilding(citizen.getWorkBuilding())) instanceof AbstractBuildingView && building.getBuildingType() != ModBuildings.library.get()) {
            this.findPaneByID("jobTab").setVisible(true);
            this.findPaneByID("jobIcon").setVisible(true);
            this.registerButton("jobTab", () -> new JobWindowCitizen(citizen).open());
            this.registerButton("jobIcon", () -> new JobWindowCitizen(citizen).open());
            PaneBuilders.tooltipBuilder().hoverPane(this.findPaneByID("jobIcon")).build().setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.citizen.job"));
        } else {
            this.findPaneByID("jobTab").setVisible(false);
            this.findPaneByID("jobIcon").setVisible(false);
        }
    }
}

