/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.Network;
import com.minecolonies.core.network.messages.server.colony.HireSpiesMessage;
import com.minecolonies.core.tileentities.TileEntityRack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class WindowsBarracksSpies
extends BOWindow
implements ButtonHandler {
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_HIRE = "hireSpies";
    private static final String SPIES_BUTTON_ICON = "hireSpiesIcon";
    private static final String GOLD_COST_LABEL = "amount";
    private static final String TEXT_ID = "text";
    private static final int GOLD_COST = 5;
    private final IBuildingView buildingView;

    public WindowsBarracksSpies(IBuildingView buildingView, BlockPos buildingPos) {
        super(new ResourceLocation("minecolonies", "gui/windowbarracksspies.xml"));
        this.buildingView = buildingView;
        ((ItemIcon)this.findPaneOfTypeByID(SPIES_BUTTON_ICON, ItemIcon.class)).setItem(Items.f_42417_.m_7968_());
        ((Text)this.findPaneOfTypeByID(GOLD_COST_LABEL, Text.class)).setText(Component.m_237113_((String)"x5"));
        IItemHandlerModifiable rackInv = ((TileEntityRack)buildingView.getColony().getWorld().m_7702_(buildingPos)).getInventory();
        InvWrapper playerInv = new InvWrapper((Container)Minecraft.m_91087_().f_91074_.m_150109_());
        int goldCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, Items.f_42417_);
        if (!buildingView.getColony().isRaiding() || (goldCount += InventoryUtils.getItemCountInItemHandler((IItemHandler)rackInv, Items.f_42417_)) < 5 || buildingView.getColony().areSpiesEnabled()) {
            ((ButtonImage)this.findPaneOfTypeByID(BUTTON_HIRE, ButtonImage.class)).disable();
        }
        ((Text)this.findPaneOfTypeByID(TEXT_ID, Text.class)).setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.barracks.spies.desc"));
    }

    public void onButtonClicked(Button button) {
        switch (button.getID()) {
            case "cancel": {
                this.close();
                break;
            }
            case "hireSpies": {
                ((ButtonImage)this.findPaneOfTypeByID(BUTTON_HIRE, ButtonImage.class)).disable();
                Network.getNetwork().sendToServer(new HireSpiesMessage(this.buildingView.getColony()));
                this.close();
            }
        }
    }
}

