/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.client.gui.ColorPalette;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WindowBannerPicker
extends Screen {
    private static final int GUI_Y = 30;
    private static final int SIDE = 20;
    private static final int PATTERN_HEIGHT = 30;
    private static final int PATTERN_WIDTH = 15;
    private static final int PATTERN_MARGIN = 3;
    private static final int PATTERN_COLUMNS = 8;
    private static final int PATTERN_ROWS = 4;
    private static final ResourceKey[][] EXCLUSION = new ResourceKey[][]{{BannerPatterns.f_222717_, BannerPatterns.f_222718_}, {BannerPatterns.f_222719_, BannerPatterns.f_222723_}, {BannerPatterns.f_222722_, BannerPatterns.f_222721_}, {BannerPatterns.f_222720_, BannerPatterns.f_222725_}, {BannerPatterns.f_222724_}, {BannerPatterns.f_222726_}};
    private final List<Holder<BannerPattern>> patterns;
    private final List<Pair<Holder<BannerPattern>, DyeColor>> layers;
    private final IColonyView colony;
    private final AbstractWindowTownHall window;
    private final ModelPart modelRender;
    private final AtomicBoolean isFeatureUnlocked;
    private ColorPalette colors;
    private int activeLayer = 0;
    private boolean scrolling = false;
    private int scrollRow = 0;

    public WindowBannerPicker(IColonyView colony, AbstractWindowTownHall hallWindow, AtomicBoolean isFeatureUnlocked) {
        super((Component)Component.m_237113_((String)"Flag"));
        this.colony = colony;
        this.window = hallWindow;
        this.modelRender = Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171264_).m_171324_("flag");
        ArrayList<Holder> exclusion = new ArrayList<Holder>();
        for (int i = ((ITownHallView)hallWindow.buildingView).getBuildingLevel(); i <= ((ITownHallView)hallWindow.buildingView).getBuildingMaxLevel(); ++i) {
            for (ResourceKey key : EXCLUSION[i]) {
                exclusion.add((Holder)BuiltInRegistries.f_256878_.m_203636_(key).get());
            }
        }
        this.patterns = BuiltInRegistries.f_256878_.m_203611_().collect(Collectors.toCollection(LinkedList::new));
        this.patterns.removeAll(exclusion);
        this.isFeatureUnlocked = isFeatureUnlocked;
        this.layers = BannerBlockEntity.m_58484_((DyeColor)DyeColor.WHITE, (ListTag)colony.getColonyFlag());
        if (this.layers.size() > 1) {
            this.layers.remove(0);
        }
    }

    protected void m_7856_() {
        int paletteX = WindowBannerPicker.center(this.f_96543_, 8, 15, 0, 0) - 70;
        this.colors = new ColorPalette(paletteX, this.f_96544_ / 2, 2, x$0 -> {
            Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
        });
        this.colors.onchange = color -> this.setLayer(null, color);
        this.createLayerButtons();
        this.createPatternButtons();
        this.createCloseButtons();
    }

    protected void createLayerButtons() {
        for (int layer = 0; layer <= 6; ++layer) {
            int posX = (this.f_96543_ - 120) / 2 + layer * 20;
            this.m_142416_((GuiEventListener)new LayerButton(posX, 30, 20, 20, layer));
        }
        this.m_142416_((GuiEventListener)new Button(WindowBannerPicker.center(this.f_96543_, 6, 20, 7, 0), 30, 20, 20, (Component)Component.m_237113_((String)(String.valueOf(ChatFormatting.RED) + "X")), pressed -> this.layers.remove(this.activeLayer), Button.f_252438_){

            public void m_88315_(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
                this.f_93623_ = WindowBannerPicker.this.activeLayer < WindowBannerPicker.this.layers.size() && WindowBannerPicker.this.activeLayer != 0;
                super.m_88315_(stack, mouseX, mouseY, partialTicks);
            }
        });
    }

    protected void createPatternButtons() {
        for (int i = 0; i < this.patterns.size(); ++i) {
            int posX = WindowBannerPicker.center(this.f_96543_, 8, 15, i % 8, 3);
            int posY = WindowBannerPicker.center(this.f_96544_ + 30, 4, 30, Math.floorDiv(i, 8), 3);
            PatternButton button = new PatternButton(posX, posY, 30, this.patterns.get(i));
            this.m_142416_((GuiEventListener)button);
            if (this.isFeatureUnlocked.get() || !((ResourceKey)this.patterns.get(i).m_203543_().get()).m_135782_().m_135827_().equals("minecolonies")) continue;
            button.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"com.minecolonies.core.gui.banner.patreon")));
            button.blocked = true;
        }
    }

    protected void createCloseButtons() {
        this.m_142416_((GuiEventListener)new Button(WindowBannerPicker.center(this.f_96543_, 2, 80, 1, 10), this.f_96544_ - 40, 80, 20, (Component)Component.m_237115_((String)"gui.done"), pressed -> {
            BannerPattern.Builder builder = new BannerPattern.Builder();
            for (Pair<Holder<BannerPattern>, DyeColor> pair : this.layers) {
                builder.m_222708_((Holder)pair.getFirst(), (DyeColor)pair.getSecond());
            }
            this.colony.setColonyFlag(builder.m_58587_());
            this.window.open();
        }, Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(WindowBannerPicker.center(this.f_96543_, 2, 80, 0, 10), this.f_96544_ - 40, 80, 20, (Component)Component.m_237115_((String)"gui.cancel"), pressed -> this.window.open(), Button.f_252438_));
    }

    public static int center(int length, int count, int side, int n, int margin) {
        return (length - count * (side + margin)) / 2 + n * (side + margin) + margin / 2;
    }

    public void setLayer(@Nullable Holder<BannerPattern> pattern, DyeColor color) {
        if (pattern == null) {
            if (this.activeLayer == this.layers.size()) {
                return;
            }
            pattern = this.activeLayer == 0 ? BuiltInRegistries.f_256878_.m_246971_(BannerPatterns.f_222726_) : (Holder)this.layers.get(this.activeLayer).getFirst();
        }
        if (this.activeLayer == this.layers.size()) {
            this.layers.add((Pair<Holder<BannerPattern>, DyeColor>)new Pair(pattern, (Object)color));
        } else {
            this.layers.set(this.activeLayer, (Pair<Holder<BannerPattern>, DyeColor>)new Pair(pattern, (Object)color));
        }
    }

    public void m_88315_(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(stack);
        super.m_88315_(stack, mouseX, mouseY, partialTicks);
        this.drawFlag();
        int scrollRows = (int)(Math.ceil((float)this.patterns.size() / 8.0f) - 4.0);
        if (scrollRows > 0 && this.activeLayer > 0) {
            int trackHeight = 132;
            double barHeight = (float)trackHeight * (4.0f / (float)(scrollRows + 4));
            int trackX = WindowBannerPicker.center(this.f_96543_, 8, 15, 8, 3);
            int trackY = (int)((float)WindowBannerPicker.center(this.f_96544_, 4, 30, 0, 3) + (float)this.scrollRow * ((float)trackHeight / (float)(scrollRows + 4)));
            stack.m_280509_(trackX + 2, trackY, trackX + 6, trackY + (int)barHeight, -1140850689);
        }
        stack.m_280137_(this.f_96547_, Component.m_237115_((String)"com.minecolonies.coremod.gui.flag.choose").getString(), this.f_96543_ / 2, 16, 0xFFFFFF);
    }

    private void drawFlag() {
        Lighting.m_84930_();
        double posX = ((double)this.f_96543_ + 120.0) / 2.0 + 40.0;
        double posY = (double)this.f_96544_ / 2.0;
        PoseStack transform = new PoseStack();
        transform.m_85837_(posX, posY + 40.0, 0.0);
        transform.m_85841_(40.0f, -40.0f, 1.0f);
        transform.m_85837_(0.5, 0.5, 0.5);
        transform.m_85841_(1.0f, -1.0f, -1.0f);
        this.renderBanner(transform, this.layers);
    }

    private void drawBannerPattern(Holder<BannerPattern> pattern, int x, int y) {
        Lighting.m_84930_();
        ArrayList<Pair<Holder<BannerPattern>, DyeColor>> list = new ArrayList<Pair<Holder<BannerPattern>, DyeColor>>();
        list.add(new Pair((Object)((Holder)BuiltInRegistries.f_256878_.m_203636_(BannerPatterns.f_222726_).get()), (Object)DyeColor.GRAY));
        if (!this.isFeatureUnlocked.get() && ((ResourceKey)pattern.m_203543_().get()).m_135782_().m_135827_().equals("minecolonies")) {
            list.add(new Pair(pattern, (Object)DyeColor.BLACK));
        } else {
            list.add(new Pair(pattern, (Object)DyeColor.WHITE));
        }
        PoseStack transform = new PoseStack();
        transform.m_85836_();
        transform.m_85837_((double)x + 2.5, (double)(y + 29), 0.0);
        transform.m_85841_(10.0f, -11.0f, 1.0f);
        transform.m_85837_(0.5, 0.5, 0.5);
        transform.m_85841_(1.0f, -1.0f, -1.0f);
        this.renderBanner(transform, list);
    }

    public void renderBanner(PoseStack transform, List<Pair<Holder<BannerPattern>, DyeColor>> layers) {
        this.modelRender.f_104203_ = 0.0f;
        this.modelRender.f_104201_ = -32.0f;
        MultiBufferSource.BufferSource source = this.f_96541_.m_91269_().m_110104_();
        BannerRenderer.m_112065_((PoseStack)transform, (MultiBufferSource)source, (int)0xF000F0, (int)OverlayTexture.f_118083_, (ModelPart)this.modelRender, (Material)ModelBakery.f_119224_, (boolean)true, layers);
        transform.m_85849_();
        source.m_109911_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.activeLayer > 0) {
            this.scrollRow = (int)Mth.m_14008_((double)((double)this.scrollRow - scroll), (double)0.0, (double)(Math.ceil(this.patterns.size() / 8) - 4.0 + 1.0));
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_231044_5_) {
        this.scrolling = false;
        int trackX = WindowBannerPicker.center(this.f_96543_, 8, 15, 8, 3);
        int trackY = WindowBannerPicker.center(this.f_96544_, 4, 30, 0, 3);
        int trackEnd = trackY + 132;
        if (mouseX > (double)(trackX + 2) && mouseX < (double)(trackX + 8) && mouseY > (double)trackY && mouseY < (double)trackEnd) {
            this.scrolling = true;
        }
        return super.m_6375_(mouseX, mouseY, p_231044_5_);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling && this.activeLayer > 0) {
            int trackStart = WindowBannerPicker.center(this.f_96544_, 4, 30, 0, 3);
            int trackLength = 132;
            double scrollRatio = Mth.m_14008_((double)((mouseY - (double)trackStart) / (double)trackLength), (double)0.0, (double)1.0);
            this.scrollRow = (int)Math.round(scrollRatio * (Math.ceil(this.patterns.size() / 8) - 4.0 + 1.0));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public class LayerButton
    extends Button {
        private final int layer;

        public LayerButton(int x, int y, int width, int height, int layer) {
            super(x - (layer == 0 ? width * 2 : 0), y, width * (layer == 0 ? 3 : 1), height, (Component)(layer == 0 ? Component.m_237115_((String)"com.minecolonies.coremod.gui.flag.base_layer") : Component.m_237113_((String)String.valueOf(layer))), pressed -> {}, f_252438_);
            this.layer = layer;
        }

        public void m_5691_() {
            WindowBannerPicker.this.activeLayer = this.layer;
            if (this.layer >= WindowBannerPicker.this.layers.size()) {
                WindowBannerPicker.this.colors.setSelected(((DyeColor)WindowBannerPicker.this.layers.get(0).getSecond()).equals((Object)DyeColor.BLACK) ? DyeColor.WHITE : DyeColor.BLACK);
            } else {
                WindowBannerPicker.this.colors.setSelected((DyeColor)WindowBannerPicker.this.layers.get(WindowBannerPicker.this.activeLayer).getSecond());
            }
        }

        public void m_88315_(GuiGraphics stack, int p_render_1_, int p_render_2_, float p_render_3_) {
            this.f_93623_ = this.layer <= WindowBannerPicker.this.layers.size();
            super.m_88315_(stack, p_render_1_, p_render_2_, p_render_3_);
            if (WindowBannerPicker.this.activeLayer == this.layer) {
                stack.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 1725798911);
            }
        }
    }

    public class PatternButton
    extends Button {
        private final Holder<BannerPattern> pattern;
        private int index;
        private boolean blocked;

        public PatternButton(int x, int y, int height, Holder<BannerPattern> pattern) {
            super(x, y, height / 2, height, (Component)Component.m_237113_((String)""), btn -> {}, f_252438_);
            this.index = -1;
            this.blocked = false;
            this.pattern = pattern;
            int tempIndex = 0;
            for (Holder<BannerPattern> pat : WindowBannerPicker.this.patterns) {
                if (((BannerPattern)pat.get()).m_58579_().equals(((BannerPattern)pattern.get()).m_58579_())) {
                    this.index = tempIndex;
                    break;
                }
                ++tempIndex;
            }
        }

        public void m_5691_() {
            if (!this.blocked) {
                WindowBannerPicker.this.setLayer(this.pattern, WindowBannerPicker.this.colors.getSelected());
            }
        }

        public void m_88315_(GuiGraphics stack, int p_render_1_, int p_render_2_, float p_render_3_) {
            this.f_93624_ = WindowBannerPicker.this.scrollRow * 8 <= this.index && this.index < 8 * (WindowBannerPicker.this.scrollRow + 4);
            boolean bl = this.f_93623_ = WindowBannerPicker.this.activeLayer != 0;
            if (!this.f_93623_ || !this.f_93624_) {
                return;
            }
            int position = Math.floorDiv(this.index - WindowBannerPicker.this.scrollRow * 8, 8);
            this.m_253211_(WindowBannerPicker.center(WindowBannerPicker.this.f_96544_, 4, 30, position, 3));
            super.m_88315_(stack, p_render_1_, p_render_2_, p_render_3_);
            try {
                WindowBannerPicker.this.drawBannerPattern(this.pattern, this.m_252754_(), this.m_252907_());
            }
            catch (Exception ex) {
                Log.getLogger().warn(((BannerPattern)this.pattern.get()).m_58579_());
                Log.getLogger().error((Object)ex);
            }
        }

        public void m_87963_(GuiGraphics stack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            if (this.blocked) {
                stack.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
            } else if (this.f_93624_) {
                if (this.f_93622_ && this.f_93623_) {
                    stack.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -570425345);
                }
                if (WindowBannerPicker.this.activeLayer < WindowBannerPicker.this.layers.size() && WindowBannerPicker.this.layers.get(WindowBannerPicker.this.activeLayer).getFirst() == this.pattern) {
                    stack.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -2258689);
                } else {
                    stack.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x33888888);
                }
            }
        }
    }
}

