/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingWindow<B extends IBuildingView>
extends AbstractWindowSkeleton {
    protected static final int MIN_VERTICAL_OFFSET = 10;
    protected static final int TAB_WIDTH = 32;
    protected static final int TAB_HEIGHT = 26;
    protected static final int TAB_X_OVERLAP = 12;
    protected static final int TAB_Y_SPACING = 2;
    protected static final int TAB_ICON_WIDTH = 20;
    protected static final int TAB_ICON_HEIGHT = 20;
    protected static final int TAB_ICON_OFFSET_X = 5;
    protected static final int TAB_ICON_OFFSET_Y = 3;
    protected final B buildingView;
    private final Random iconRandom;

    public AbstractBuildingWindow(B buildingView, ResourceLocation resource) {
        this(null, buildingView, resource);
    }

    public AbstractBuildingWindow(BOWindow parent, B buildingView, ResourceLocation resource) {
        super(parent, resource);
        this.buildingView = buildingView;
        this.iconRandom = new Random(buildingView.getID().hashCode());
        int nextTabIndex = 0;
        this.renderTabButton(nextTabIndex++, TabImageSide.LEFT, new ResourceLocation("minecolonies", "textures/gui/modules/main.png"), Component.m_237115_((String)"com.minecolonies.coremod.gui.maintab"), button -> buildingView.getWindow().open());
        List<IBuildingModuleView> allModuleViews = buildingView.getAllModuleViews();
        for (IBuildingModuleView view : allModuleViews) {
            if (!view.isPageVisible()) continue;
            this.renderTabButton(nextTabIndex++, TabImageSide.LEFT, view.getIconResourceLocation(), Optional.ofNullable(view.getDesc()).map(Component::m_6881_).orElse(null), button -> {
                this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                view.getWindow().open();
            });
        }
    }

    protected void renderTabButton(int index, TabImageSide side, ResourceLocation icon, @Nullable MutableComponent hoverText, ButtonHandler handler) {
        View view = new View();
        view.setID(icon.m_135815_() + "_view");
        view.setPosition(side.getXPosition.apply(this.window).intValue(), 10 + 28 * index);
        view.setSize(32, 26);
        ButtonImage image = new ButtonImage();
        image.setImage(side.getImage(this.iconRandom), false);
        image.setSize(32, 26);
        image.setHandler(handler);
        ButtonImage iconImage = new ButtonImage();
        iconImage.setID(icon.m_135815_());
        iconImage.setImage(icon, false);
        iconImage.setSize(20, 20);
        iconImage.setPosition(5, 3);
        iconImage.setHandler(handler);
        this.addChild((Pane)view);
        view.addChild((Pane)image);
        view.addChild((Pane)iconImage);
        if (hoverText != null) {
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(hoverText)).hoverPane((Pane)view).build();
        }
    }

    @Override
    public void setPage(boolean relative, int page) {
        super.setPage(relative, page);
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
    }

    public static enum TabImageSide {
        LEFT("left", 4, v -> -20),
        RIGHT("right", 4, v -> v.getWidth() - 12);

        private final String side;
        private final int imageCount;
        private final Function<BOWindow, Integer> getXPosition;

        private TabImageSide(String side, int imageCount, Function<BOWindow, Integer> getXPosition) {
            this.side = side;
            this.imageCount = imageCount;
            this.getXPosition = getXPosition;
        }

        public ResourceLocation getImage(Random random) {
            return new ResourceLocation("minecolonies", String.format("textures/gui/modules/tab_%s_side%d.png", this.side, random.nextInt(this.imageCount) + 1));
        }
    }
}

