/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks.huts;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.core.client.gui.modules.ConnectionModuleWindow;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockHutGateHouse
extends AbstractBlockHut<BlockHutGateHouse> {
    @Override
    @NotNull
    public String getHutName() {
        return "blockhutgatehouse";
    }

    @Override
    public BuildingEntry getBuildingEntry() {
        return (BuildingEntry)ModBuildings.gateHouse.get();
    }

    @Override
    public boolean canRightClickWithoutPermissions() {
        return true;
    }

    @Override
    @NotNull
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.f_46443_) {
            if (hand == InteractionHand.OFF_HAND) {
                return InteractionResult.FAIL;
            }
            @Nullable IBuildingView building = IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.m_46472_(), pos);
            if (building != null && !building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                new ConnectionModuleWindow(building, true).open();
                return InteractionResult.FAIL;
            }
            return super.m_6227_(state, worldIn, pos, player, hand, ray);
        }
        IColony colony = IColonyManager.getInstance().getIColony(worldIn, pos);
        if (colony != null && !colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }
}

