/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.connections;

import com.minecolonies.api.colony.connections.ColonyConnectionNode;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PendingConnectionNode
extends ColonyConnectionNode {
    private PendingConnectionType connectionType;
    private PathResult<PathJobMoveToLocation> cachedPathResult;

    public PendingConnectionNode(BlockPos pos, PathResult<PathJobMoveToLocation> pathResult, PendingConnectionType connectionType) {
        super(pos);
        this.cachedPathResult = pathResult;
        this.connectionType = connectionType;
    }

    public PendingConnectionNode(BlockPos pos) {
        super(pos);
    }

    @Override
    public CompoundTag write() {
        CompoundTag compound = super.write();
        compound.m_128405_("connectiontype", this.connectionType.ordinal());
        return compound;
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        super.read(compound);
        this.connectionType = PendingConnectionType.values()[compound.m_128451_("connectiontype")];
    }

    public PendingConnectionType getPendingConnectionType() {
        return this.connectionType;
    }

    public void setCachedPathResult(PathResult<PathJobMoveToLocation> cachedPathResult) {
        this.cachedPathResult = cachedPathResult;
    }

    @Nullable
    public PathResult<PathJobMoveToLocation> getCachedPathResult() {
        return this.cachedPathResult;
    }

    public static enum PendingConnectionType {
        DEFAULT,
        FIX_PATH,
        CONNECT_COLONY;

    }
}

