/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements.open_gui_window;

import com.google.gson.JsonObject;
import com.minecolonies.core.util.GsonHelper;
import java.util.Objects;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class OpenGuiWindowCriterionInstance
extends AbstractCriterionTriggerInstance {
    private ResourceLocation windowResource;

    public OpenGuiWindowCriterionInstance() {
        super(new ResourceLocation("minecolonies", "open_gui_window"), ContextAwarePredicate.f_285567_);
    }

    public OpenGuiWindowCriterionInstance(ResourceLocation windowResource) {
        super(new ResourceLocation("minecolonies", "open_gui_window"), ContextAwarePredicate.f_285567_);
        this.windowResource = windowResource;
    }

    public boolean test(ResourceLocation windowResource) {
        return Objects.equals(this.windowResource, windowResource);
    }

    @NotNull
    public static OpenGuiWindowCriterionInstance deserializeFromJson(@NotNull JsonObject jsonObject, @NotNull DeserializationContext context) {
        if (jsonObject.has("window_resource_location")) {
            ResourceLocation windowResource = GsonHelper.getAsResourceLocation(jsonObject, "window_resource_location");
            return new OpenGuiWindowCriterionInstance(windowResource);
        }
        return new OpenGuiWindowCriterionInstance();
    }

    @NotNull
    public JsonObject m_7683_(@NotNull SerializationContext context) {
        JsonObject json = super.m_7683_(context);
        if (this.windowResource != null) {
            json.addProperty("window_resource_location", this.windowResource.toString());
        }
        return json;
    }
}

