/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import guideme.Guide;
import guideme.Guides;
import guideme.PageAnchor;
import guideme.internal.GuideMEClient;
import guideme.internal.GuidebookText;
import guideme.internal.command.GuideIdArgument;
import guideme.internal.command.PageAnchorArgument;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class GuideClientCommand {
    private GuideClientCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder rootCommand = Commands.m_82127_((String)"guidemec");
        rootCommand.then(((RequiredArgumentBuilder)Commands.m_82129_((String)"guide", (ArgumentType)GuideIdArgument.argument()).then(Commands.m_82127_((String)"export").executes(context -> {
            ResourceLocation guide = GuideIdArgument.getGuide(context, "guide");
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"open").executes(context -> {
            ResourceLocation guideId = GuideIdArgument.getGuide(context, "guide");
            Guide guide = Guides.getById(guideId);
            if (guide == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)GuidebookText.ItemInvalidGuideId.text(guideId.toString()));
                return 1;
            }
            GuideMEClient.openGuideAtPreviousPage(guide, guide.getStartPage());
            return 0;
        })).then(Commands.m_82129_((String)"page", (ArgumentType)PageAnchorArgument.argument()).executes(context -> {
            ResourceLocation guideId = GuideIdArgument.getGuide(context, "guide");
            Guide guide = Guides.getById(guideId);
            PageAnchor anchor = PageAnchorArgument.getPageAnchor((CommandContext<CommandSourceStack>)context, "page");
            GuideMEClient.openGuideAtAnchor(guide, anchor);
            return 0;
        }))));
        dispatcher.register(rootCommand);
    }
}

