/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.components;

import java.awt.Color;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.render.Colors;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.lib.mod.client.render.pipeline.RenderPipelines;
import su.plo.lib.mod.client.render.shader.SolidColorShader;
import su.plo.slib.api.chat.component.McTextComponent;

public final class IconButton
extends Button {
    private final boolean shadow;
    private final Color shadowColor;
    private ResourceLocation iconLocation;
    @Nullable
    private Color iconColor = null;

    public IconButton(int x, int y, int width, int height, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, @NotNull ResourceLocation iconLocation, boolean shadow) {
        this(x, y, width, height, pressAction, tooltipAction, iconLocation, shadow, Colors.WHITE);
    }

    public IconButton(int x, int y, int width, int height, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, @NotNull ResourceLocation iconLocation, boolean shadow, Color shadowColor) {
        super(x, y, width, height, McTextComponent.empty(), pressAction, tooltipAction);
        this.iconLocation = iconLocation;
        this.shadow = shadow;
        this.shadowColor = shadowColor;
    }

    @Override
    public void renderButton(@NotNull GuiRenderContext context, int mouseX, int mouseY, float delta) {
        Color iconColor;
        super.renderButton(context, mouseX, mouseY, delta);
        if (this.hasShadow() && SolidColorShader.isAvailable()) {
            Color shadowColor = this.active ? this.shadowColor : Colors.GRAY;
            context.blitColor(this.iconLocation, this.x + 2, this.y + 3, 0.0f, 0.0f, 16, 16, 16, 16, Colors.times(shadowColor, 0.25), RenderPipelines.GUI_TEXTURE_SOLID_COLOR);
        }
        if ((iconColor = this.iconColor) == null && !this.active) {
            iconColor = Colors.GRAY;
        }
        if (iconColor != null) {
            context.blitColor(this.iconLocation, this.x + 2, this.y + 2, 0.0f, 0.0f, 16, 16, 16, 16, iconColor);
        } else {
            context.blit(this.iconLocation, this.x + 2, this.y + 2, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public ResourceLocation getIconLocation() {
        return this.iconLocation;
    }

    public void setIconLocation(ResourceLocation iconLocation) {
        this.iconLocation = iconLocation;
    }

    @Nullable
    public Color getIconColor() {
        return this.iconColor;
    }

    public void setIconColor(@Nullable Color iconColor) {
        this.iconColor = iconColor;
    }
}

