/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.util;

import net.minecraft.util.Mth;

public class ColorAndAlphaInterpolator {
    private int startColor;
    private int endColor;
    private float startAlpha;
    private float endAlpha;
    private float transitionTime;
    private float elapsedTime;

    public ColorAndAlphaInterpolator(int startColor, int endColor, float startAlpha, float endAlpha, float transitionTime) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.startAlpha = startAlpha;
        this.endAlpha = endAlpha;
        this.transitionTime = transitionTime;
        this.elapsedTime = 0.0f;
    }

    public int updateAndGetColor(float deltaTime, float globalAlpha) {
        this.elapsedTime += deltaTime;
        float t = Mth.m_14036_((float)(this.elapsedTime / this.transitionTime), (float)0.0f, (float)1.0f);
        return this.lerpColor(this.startColor, this.endColor, t, globalAlpha);
    }

    public float updateAndGetAlpha(float deltaTime) {
        this.elapsedTime += deltaTime;
        float t = Mth.m_14036_((float)(this.elapsedTime / this.transitionTime), (float)0.0f, (float)1.0f);
        return Mth.m_14179_((float)t, (float)this.startAlpha, (float)this.endAlpha);
    }

    private int lerpColor(int startColor, int endColor, float t, float globalAlpha) {
        int startA = startColor >> 24 & 0xFF;
        int startR = startColor >> 16 & 0xFF;
        int startG = startColor >> 8 & 0xFF;
        int startB = startColor & 0xFF;
        int endA = endColor >> 24 & 0xFF;
        int endR = endColor >> 16 & 0xFF;
        int endG = endColor >> 8 & 0xFF;
        int endB = endColor & 0xFF;
        int a = (int)(Mth.m_14179_((float)t, (float)startA, (float)endA) * globalAlpha);
        int r = (int)Mth.m_14179_((float)t, (float)startR, (float)endR);
        int g = (int)Mth.m_14179_((float)t, (float)startG, (float)endG);
        int b = (int)Mth.m_14179_((float)t, (float)startB, (float)endB);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public void resetTransition(int startColor, int endColor, float startAlpha, float endAlpha, float transitionTime) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.startAlpha = startAlpha;
        this.endAlpha = endAlpha;
        this.transitionTime = transitionTime;
        this.elapsedTime = 0.0f;
    }
}

