/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.network.packet;

import java.util.function.Supplier;
import net.mezimaru.mastersword.entity.custom.HookshotHookProjectileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class HookshotRetractingS2CPacket {
    private final int projectileEntityId;
    private final boolean isRetracting;

    public HookshotRetractingS2CPacket(FriendlyByteBuf buffer) {
        this.projectileEntityId = buffer.readInt();
        this.isRetracting = buffer.readBoolean();
    }

    public HookshotRetractingS2CPacket(int projectileEntityId, Boolean isRetracting) {
        this.projectileEntityId = projectileEntityId;
        this.isRetracting = isRetracting;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.projectileEntityId);
        buffer.writeBoolean(this.isRetracting);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(this.projectileEntityId)) instanceof HookshotHookProjectileEntity) {
                ((HookshotHookProjectileEntity)entity).setShouldRetract(this.isRetracting);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

