/*
 * Decompiled with CFR 0.152.
 */
package net.mezimaru.mastersword.network.packet;

import java.util.UUID;
import java.util.function.Supplier;
import net.mezimaru.mastersword.entity.custom.HookshotHookProjectileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class HookshotOwnerS2CPacket {
    private final int projectileEntityId;
    private final UUID shooterUUID;
    private final InteractionHand usedItemHand;
    private final float shooterPitch;

    public HookshotOwnerS2CPacket(FriendlyByteBuf buffer) {
        this.projectileEntityId = buffer.readInt();
        this.shooterUUID = buffer.m_130259_();
        this.usedItemHand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        this.shooterPitch = buffer.readFloat();
    }

    public HookshotOwnerS2CPacket(int projectileEntityId, UUID shooterUUID, InteractionHand usedItemHand, float shooterPitch) {
        this.projectileEntityId = projectileEntityId;
        this.shooterUUID = shooterUUID;
        this.usedItemHand = usedItemHand;
        this.shooterPitch = shooterPitch;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeInt(this.projectileEntityId);
        buffer.m_130077_(this.shooterUUID);
        buffer.m_130068_((Enum)this.usedItemHand);
        buffer.writeFloat(this.shooterPitch);
    }

    public boolean handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(this.projectileEntityId)) instanceof HookshotHookProjectileEntity) {
                ((HookshotHookProjectileEntity)entity).setShootingPlayerUUID(this.shooterUUID);
                ((HookshotHookProjectileEntity)entity).setActiveItemHand(this.usedItemHand);
                ((HookshotHookProjectileEntity)entity).setShooterPitch(this.shooterPitch);
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

